% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_shapepull.R
\name{sd_shapepull}
\alias{sd_shapepull}
\title{A function to import school district shapefiles}
\format{Simple feature collection with 6 fields and geometry Multi Polygon: \describe{
  \item{GEOID}{Unique school district ID, character} \item{NAME}{School
  district name, character string} \item{sdType}{School district level,
  character string} \item{FIPS}{State ID, character} \item{State}{State name,
  character} \item{Postal}{State postal code, character}
  \item{geometry}{sfc_MULTIPOLYGON} }}
\source{
\url{https://s3.amazonaws.com/data.edbuild.org/public/Processed+Data/SD+shapes/2019/shapefile_1819.zip}
}
\usage{
sd_shapepull(data_year = "2019", with_data=FALSE)
}
\arguments{
\item{data_year}{Four digit year of shapefile data you would like to pull.
Available for any school year from 2013 to 2019.}

\item{with_data}{TRUE to attach EdBuild's school district master dataset to
shapefile. Defaults to FALSE.}
}
\value{
A spatial object where each row is a school district.
}
\description{
This function allows you to import a simplified version of the US Census
Bureau, Education Demographic and Geographic Estimates Program (EDGE),
Composite School District Boundaries File.
}
\examples{
\donttest{sd_shp_19 <- sd_shapepull("2019")}
}
\keyword{EdBuild}
\keyword{shapefile}
