
<!-- README.md is generated from README.Rmd. Please edit that file -->

# edbuildr

<!-- badges: start -->

<!-- badges: end -->

The goal of `edbuildr` is to import EdBuild’s master dataset of school
district finance, student demographics, and community economic
indicators for every school district in the United States.  
The master dataset is built from the US Census, Annual Survey of School
System Finances (F33) and joins data from the National Center for
Education Statistics, Common Core of Data (CCD); the US Census, Small
Area Income and Poverty Estimates (SAIPE); and the US Census, Education
Demographic and Geographic Estimates (EDGE). We apply EdBuild’s standard
processing to the dataset and provide the option to select from four
different exclusion criteria - see the masterpull help file for full
details. The master dataset is available for any school year from 2013
to 2018 or longitudinally for all years 2013-2018. School year is
identified by the end year. For example, the 2017-18 school year is
2018. Additional functions in the package use EdBuild’s master data to
analyze the difference between neighboring school districts and create
formatted excel tables of school district data. For full details about
EdBuild’s data processing please see EdBuild (2020)
<http://data.edbuild.org/>.

## Installation

You can install the released version of edbuild from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("edbuildr")
```

## Example

To view school district finance data for all districts:

``` r
library(edbuildr)
## To import EdBuild's master dataset of school district finance, student demographic, and community economic data for 2017:
master_18 <- masterpull(data_year = "2018")

str(master_18)
#> 'data.frame':    13113 obs. of  42 variables:
#>  $ NCESID              : chr  "0100240" "0100270" "0100300" "0101410" ...
#>  $ state_id            : chr  "AL-001" "AL-002" "AL-003" "AL-133" ...
#>  $ State               : chr  "Alabama" "Alabama" "Alabama" "Alabama" ...
#>  $ STATE_FIPS          : chr  "01" "01" "01" "01" ...
#>  $ NAME                : chr  "Autauga County School District" "Baldwin County School District" "Barbour County School District" "Eufaula City School District" ...
#>  $ County              : chr  "Autauga County" "Baldwin County" "Barbour County" "Barbour County" ...
#>  $ CONUM               : chr  "1001" "1003" "1005" "1005" ...
#>  $ ENROLL              : int  9247 31782 824 4619 3252 7774 1499 1462 3061 2033 ...
#>  $ LRPP                : num  2058 5822 2818 1587 1995 ...
#>  $ SRPP                : num  5762 4814 6333 5027 6706 ...
#>  $ SLRPP               : num  7820 10636 9150 6614 8701 ...
#>  $ LR                  : num  1.90e+07 1.85e+08 2.32e+06 7.33e+06 6.49e+06 ...
#>  $ SR                  : num  5.33e+07 1.53e+08 5.22e+06 2.32e+07 2.18e+07 ...
#>  $ SLR                 : num  7.23e+07 3.38e+08 7.54e+06 3.06e+07 2.83e+07 ...
#>  $ SRPP_cola           : num  6059 5057 7075 5617 7460 ...
#>  $ LRPP_cola           : num  2164 6116 3149 1773 2219 ...
#>  $ SLRPP_cola          : num  8222 11172 10224 7390 9679 ...
#>  $ dType               : chr  "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" ...
#>  $ dUrbanicity         : chr  "41-Rural: Fringe" "41-Rural: Fringe" "43-Rural: Remote" "41-Rural: Fringe" ...
#>  $ dOperational_schools: int  15 45 3 5 9 17 3 4 7 7 ...
#>  $ dEnroll_district    : int  9247 31782 824 4619 3252 7774 1499 1462 3061 2033 ...
#>  $ dFRL                : int  4014 15410 772 2673 2002 4229 677 NA 2423 1669 ...
#>  $ FRL_rate            : num  0.434 0.485 0.937 0.579 0.616 ...
#>  $ dIEP                : int  1055 4656 82 478 521 967 119 161 311 221 ...
#>  $ dLEP                : int  147 1147 60 108 47 364 99 125 8 24 ...
#>  $ dWhite              : int  6171 22844 45 2281 2364 6418 999 17 1052 97 ...
#>  $ dBlack              : int  2334 3753 652 1962 732 114 64 1225 1921 1832 ...
#>  $ dHispanic           : int  292 2894 120 284 111 1171 352 218 34 85 ...
#>  $ dAsian_PI           : int  208 279 NA 52 8 16 14 2 15 6 ...
#>  $ dHawaiian_PI        : int  11 23 2 14 NA 4 1 NA 2 1 ...
#>  $ dAmIndian_Aknative  : int  28 99 3 11 4 10 5 NA 5 2 ...
#>  $ d2plus_races        : int  203 1890 2 15 33 41 64 NA 32 10 ...
#>  $ pctNonwhite         : num  0.333 0.281 0.945 0.506 0.273 ...
#>  $ TPop                : int  55601 218022 12978 11903 22400 51201 6639 10138 19680 22163 ...
#>  $ StPop               : int  9799 35155 1671 2237 3302 8919 1013 1537 3259 3100 ...
#>  $ StPov               : int  1891 4534 639 772 840 1357 163 1005 1131 1180 ...
#>  $ StPovRate           : num  0.193 0.129 0.382 0.345 0.254 ...
#>  $ MPV                 : int  147900 189800 67600 127600 96500 122000 161500 77500 88300 96900 ...
#>  $ MHI                 : int  58786 55962 33892 34550 45340 48898 45217 32152 39109 33688 ...
#>  $ sd_area             : num  604.4 1609.9 831 73.5 626.2 ...
#>  $ student_per_sq_mile : num  15.299 19.742 0.992 62.844 5.193 ...
#>  $ sd_type             : chr  "uni" "uni" "uni" "uni" ...
```

## Authors

  - Megan Brodzik (<meganbrodzik@gmail.com>), maintainer
  - Cecilia Depman (<cecilia.depman@gmail.com>), author
  - Sara Hodges (<sara.hodges@gmail.com>), author
  - Kailey Spencer (<kailey.spencer.depoe@gmail.com>), contributor
