% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_table_xlsx.R
\name{sd_table_xlsx}
\alias{sd_table_xlsx}
\title{A function to create a table of school districts in a selected state
  or county}
\usage{
sd_table_xlsx(data_year = '2019', state = "New Jersey", county = NULL,
  table_vars = c('Name', 'Enrollment', 'Poverty Rate', 'Percent Nonwhite',
  'Local Revenue PP', 'State Revenue PP', 'Total Revenue PP'))
}
\arguments{
\item{data_year}{Four digit year of master data to pull in. Options include
2013- 2019. Defaults to 2019.}

\item{state}{State name. Defaults to New Jersey.}

\item{county}{County name. Defaults to NULL.}

\item{table_vars}{Variable or list of variables to include in the table. Use
tables_vars = “options” to print a list of the variables. Defaults to:
Name; Enrollment; Poverty Rate; Percent Nonwhite; Local Revenue, Per Pupil;
State Revenue, Per Pupil; Total Revenue, Per Pupil.}
}
\value{
An excel workbook which can be written out with
  \code{openxlsx::saveWorkbook(my_table, file =
  '~/Documents/state_year.xlsx', overwrite = TRUE)}
}
\description{
This function allows you to write out a table of any school
  districts with selected data as a formatted excel file.
}
\examples{
\donttest{my_table <- sd_table_xlsx(data_year = "2019",
            state = "Maryland",
            county = c("Baltimore County", "Baltimore City", "Howard County", "Carroll County"),
            table_vars = c("Name", "Poverty Rate")
             )}
}
\seealso{
\code{\link{sd_neighbor_xlsx}}, \code{\link{master_codebook}},
  \code{\link{masterpull}}
}
\keyword{EdBuild}
\keyword{difference}
\keyword{neighbors}
\keyword{table}
