% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf_band.R
\name{conf_band}
\alias{conf_band}
\title{Confidence Bounds of the Smoother}
\usage{
conf_band(bt_smoother, smoother_pts, bt_tot_rep, conf_band_lvl)
}
\arguments{
\item{bt_smoother}{A data frame containing the bootstrapped smoother. Use the output of \code{bt_smoother}.}

\item{smoother_pts}{A data frame containing the smoother. Preferably the
output of one of the smoother functions included in this package.}

\item{bt_tot_rep}{The number of iterations for the bootstrap computation. Because of
run time, it is recommended to keep this number below 500. Defaults to 100.}

\item{conf_band_lvl}{The confidence level for the simultaneous confidence
bands. Defaults to 0.95. When detection of events using only the smoother
is desired, \code{conf_band_lvl} can be chosen to be 0.}
}
\value{
A data frame containing the upper confidence bound, the lower confidence bound,
and the time point corresponding to the bounds.
}
\description{
Calculate the confidence bounds of the smoother function using the bootstrap.
}
\details{
The procedure is as follows:
\enumerate{
\item We compute the quantiles \deqn{ q_x(t_i), q_{1-x}(t_i) i = 1,\dots, N}
where \deqn{q_x(t_i) = inf\left\{u; P^*[S(t_i)^*_b - S(t_i) \le u] \ge x\right\} } is a
pointwise bootstrap quantile, \eqn{S(t_i)^*_b} the bootstrapped smoother,
and \eqn{N} the number of measurements or rows in \code{data}, in our case the number of rows.
\item We vary the pointwise error \eqn{x} until \deqn{P^*[q_x(t_i) \le S(t_i)^*_b - S(t_i) \le q_{1-x}(t_i) \forall i = 1,\dots, N] \approx 1-\alpha.}
In other words, until the ratio of bootstrap curves that have all their points within
\eqn{[q_x(t_i), q_{1-x}(t_i)]} is approximately \eqn{1-\alpha}.
\item We define
\deqn{ I_n(t_i) = [S(t_i) +  q_x(t_i), S(t_i) + q_{1-x}(t_i)] \forall i = 1,\dots, N}
the confidence bounds. Then \eqn{{I_n(t_i); i = 1,\dots, N}} is a consistent simultaneous confidence band of level \eqn{1-\alpha}.

}
}
\references{
Bühlmann, P. (1998). Sieve Bootstrap for Smoothing in
Nonstationary Time Series. \emph{The Annals of Statistics}, 26(1), 48-83.
}
