% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.r
\name{prior_ff}
\alias{prior_ff}
\alias{prior_grow}
\title{Priors for \code{\link{estimatetransprobs}}}
\usage{
prior_ff()

prior_grow(variable, howmuch = 1)
}
\arguments{
\item{variable}{Name of the variable to grow}

\item{howmuch}{Amount of growth}
}
\value{
Return value is used by \code{\link{estimatetransprobs}} to provide
prior information on the transition probabilities.
}
\description{
Priors for \code{\link{estimatetransprobs}}
}
\details{
\code{prior_ff} moves the forest area to the smallest classes of the given
dynamic variables of the forest stratum.

\code{prior_grow} moves the forest to another class given by increasing
\code{variable} by \code{howmuch}.
}
\examples{
statespace <- expand.grid(a=1:2, b=1:2, vol=1:15, age=1:35)
act <- define_activity("test", c("vol", "age"))
act1 <- estimatetransprobs(c("vol", "age"), NULL, statespace, by=c("a", "b"),
  prior=prior_ff())
act2 <- estimatetransprobs(c("vol", "age"), NULL, statespace, by=c("a", "b"),
  prior=prior_grow("age"))
}
