% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effector.summary.R
\name{effector.summary}
\alias{effector.summary}
\title{Returns non-redundant sequences from hmm.search or regex.search and generates a motif table}
\usage{
effector.summary(hmm.result, motif = "RxLR", reg.pat = NULL)
}
\arguments{
\item{hmm.result}{A list of \code{SeqFastadna} objects obtained from \code{\link{regex.search}} or \code{\link{hmm.search}}}

\item{motif}{A character string indicating the motif of interest. Motifs for two cytoplasmic effectors are added to the function: \code{RxLR} or \code{CRN} effectors. Each of these motifs are associated with a by-default REGEX (\code{reg.pat}). A third option, \code{custom}, allows for the search of custom motifs. The \code{custom} option requires the specification of the motif REGEX pattern in the \code{reg.pat} option, in a \code{\link{regex}} format. Default is RxLR}

\item{reg.pat}{A character string indicating the REGEX pattern for the \code{custom} motif. The specification of the REGEX pattern in must be in \code{\link{regex}} format. Required for \code{custom} option of \code{motif}}
}
\value{
A list of two objects: Summary motif table and non-redundant sequences (only with results of \code{\link{hmm.search}})
}
\description{
This function summarize the results from \code{\link{regex.search}} or \code{\link{hmm.search}}.
}
\examples{
\dontrun{

fasta.file <- system.file("extdata", "test_infestans.fasta", package = "effectR")
ORF <- seqinr::read.fasta(fasta.file)
REGEX <- regex.search(ORF, motif='RxLR')
candidate.rxlr <- hmm.search(original.seq = fasta.file, regex.seq=REGEX, num.threads = 2)
effector.summary(candidate.rxlr)
# Custom motifs
reg.pat <- "^\\\\w{50,60}[w,v]"
REGEX <- regex.search(sequence = ORF, motif = "custom", reg.pat = reg.pat)
candidate.custom <- hmm.search(original.seq = fasta.file, regex.seq = REGEX)
effector.summary(candidate.custom, motif = "custom", reg.pat = reg.pat)

}
}
\keyword{effector}
\keyword{regex}
