% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_anova.R
\name{eta2_to_f2}
\alias{eta2_to_f2}
\alias{eta2_to_f}
\alias{f2_to_eta2}
\alias{f_to_eta2}
\title{Convert between ANOVA effect sizes}
\usage{
eta2_to_f2(es)

eta2_to_f(es)

f2_to_eta2(f2)

f_to_eta2(f)
}
\arguments{
\item{es}{Any measure of variance explained such as Eta-, Epsilon-, Omega-,
or R-Squared, partial or otherwise. See details.}

\item{f, f2}{Cohen's \emph{f} or \emph{f}-squared.}
}
\description{
Convert between ANOVA effect sizes
}
\details{
Any measure of variance explained can be converted to a corresponding Cohen's
\emph{f} via:
\cr\cr
\deqn{f^2 = \frac{\eta^2}{1 - \eta^2}}
\cr\cr
\deqn{\eta^2 = \frac{f^2}{1 + f^2}}
\cr\cr
If a partial Eta-Squared is used, the resulting Cohen's \emph{f} is a
partial-Cohen's \emph{f}; If a less biased estimate of variance explained is used
(such as Epsilon- or Omega-Squared), the resulting Cohen's \emph{f} is likewise a
less biased estimate of Cohen's \emph{f}.
}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences
(2nd Ed.). New York: Routledge.
\item Steiger, J. H. (2004). Beyond the F test: Effect size confidence intervals
and tests of close fit in the analysis of variance and contrast analysis.
Psychological Methods, 9, 164-182.
}
}
\seealso{
\code{\link[=eta_squared]{eta_squared()}} for more details.

Other convert between effect sizes: 
\code{\link{d_to_common_language}()},
\code{\link{d_to_r}()},
\code{\link{odds_to_probs}()},
\code{\link{oddsratio_to_riskratio}()}
}
\concept{convert between effect sizes}
