% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_dimensions.R
\name{create_time_info}
\alias{create_time_info}
\title{Helper function to create the definition of the time dimension for use in a netCDF file}
\usage{
create_time_info(from, n, time_step = "hours since", time_step_delta = 1L,
  tzoffset)
}
\arguments{
\item{from}{the start date of the time axis}

\item{n}{length of the time dimension}

\item{time_step}{unit prefix in the time dimension units}

\item{time_step_delta}{integer, length of time units between each steps}

\item{tzoffset}{an optional character, the time offset from UTC, e.g. '+1000' for 10 hours ahead of UTC. Can be missing, in which case 'from' must be explicitly a UTC time. Note that the tzoffset completely supersedes the time zone if present.}
}
\value{
A list with keys units and values
}
\description{
Helper function to create the definition of the time dimension for use in a netCDF file. Defaults to create an hourly axis.
}
\examples{
timeAxisStart <- ISOdate(2015, 10, 4, 0, 0, 0, tz = "Australia/Canberra")
(time_dim_info <- create_time_info(from = timeAxisStart, n = 24L, 
  time_step = "hours since", time_step_delta = 3L, tzoffset = "+1000"))

# Note that the time zone information of thes sart date is NOT 
# used by create_time_info; the tzoffset argument takes precedence 
timeAxisStart <- ISOdate(2015, 10, 4, 0, 0, 0, tz = "Australia/Perth")
(time_dim_info <- create_time_info(from = timeAxisStart, n = 24L, 
  time_step = "hours since", time_step_delta = 3L, tzoffset = "+1000"))

}
\seealso{
See
   \code{\link{create_efts}} for examples
}
