% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.ego.folders.R
\name{read_egonet}
\alias{read_egonet}
\title{Read ego-centered network data exported with EgoNet software as an \code{egor} object}
\usage{
read_egonet(egos.file, alter.folder, edge.folder, csv.sep = ",",
  ID.vars = list(ego = "egoID", alter = "alterID", source = "Source", target =
  "Target"), first.col.row.names = FALSE, ...)
}
\arguments{
\item{egos.file}{File name of the .csv file containing the ego data.}

\item{alter.folder}{Folder name of the folder containing the alter data in
separate .csv files for each ego/ network.}

\item{edge.folder}{Folder name of the folder containing the edge/ tie data in
separate .csv files for each ego/ network.}

\item{csv.sep}{\code{Character} indicating the separator used in csv files.}

\item{ID.vars}{A named list containing column names of the relevant
  input columns: \describe{

\item{`ego`}{unique identifier associated with each ego, defaulting
  to `"egoID"`; has no effect if `alters.df` and `aaties.df` are
  both lists of data frames.}

\item{`alter`}{unique-within-ego identifier associated with each
  alter, defaulting to `"alterID"`; optional `aaties.df` are not
  provided.}

\item{`source`}{if `aaties.df` is provided, the column given the
  alter identifier of the origin of a relation.}

\item{`target`}{if `aaties.df` is provided, the column given the
  alter identifier of the destination of a relation.}

}}

\item{first.col.row.names}{\code{Boolean} indicating if first column contains
row names, that are to be skipped, default is \code{FALSE}.}

\item{...}{additional arguments to \code{\link[=egor]{egor()}}.}
}
\value{
A \code{list} of six objects - the **egoR** object: (1) egos.df: \code{dataframe} of all
egos and their attributes; (2) alters.df: \code{dataframe} of all alters;
(3) alters.list: \code{list} of \code{dataframes} of all alters per ego;
(4) edges: \code{list} of \code{dataframes} with edge lists per network; (5)
graphs: \code{list} of igraph objects; (6) results: a result \code{dataframe},
pre-populated with the network size of each network
}
\description{
This function imports ego-centered network data from folders with separate
files for alters-level and edge data. It will run some basic checks upon
the completeness of the data and inform the user of potential problems. This
function can be used to import data exported from EgoNet (McCarty 2011).
}
\examples{
egos.file <-  system.file("extdata", "egos_32.csv", package = "egor")
alters.folder <- system.file("extdata", "alters_32", package = "egor")
edge.folder <-  system.file("extdata", "edges_32", package = "egor")

ef <- read_egonet(egos.file = egos.file, 
                          alter.folder = alters.folder, 
                          edge.folder = edge.folder, 
                          csv.sep = ";")
}
\keyword{ego-centered}
\keyword{import}
