% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ego_gram.R, R/plot_ego_graph.R,
%   R/plot_egor.R
\name{plot_egograms}
\alias{plot_egograms}
\alias{plot_ego_graphs}
\alias{plot_egor}
\alias{plot.egor}
\title{Plotting \emph{egor} objects}
\usage{
plot_egograms(
  x,
  ego_no = 1,
  x_dim = 1,
  y_dim = 1,
  venn_var = NULL,
  pie_var = NULL,
  vertex_size_var = NULL,
  vertex_color_var = NULL,
  vertex_color_palette = "Heat Colors",
  vertex_color_legend_label = vertex_color_var,
  vertex_label_var = "name",
  edge_width_var = NULL,
  edge_color_var = NULL,
  edge_color_palette = "Heat Colors",
  highlight_box_col_var = NULL,
  highlight_box_col_palette = "Heat Colors",
  res_disp_vars = NULL,
  vertex_zoom = 1,
  edge_zoom = 2,
  font_size = 1,
  pie_colors = NULL,
  venn_gradient_reverse = FALSE,
  show_venn_labels = TRUE,
  include_ego = FALSE,
  ...
)

plot_ego_graphs(
  x,
  ego_no = 1,
  x_dim = 1,
  y_dim = 1,
  vertex_size_var = NULL,
  vertex_color_var = NULL,
  vertex_color_palette = "Heat Colors",
  vertex_color_legend_label = vertex_color_var,
  vertex_label_var = "name",
  edge_width_var = NULL,
  ego_alter_edge_width_var = if (!is.null(edge_width_var) & include_ego) edge_width_var,
  edge_color_var = NULL,
  ego_alter_edge_color_var = if (!is.null(edge_color_var) & include_ego) edge_color_var,
  edge_color_palette = "Heat Colors",
  highlight_box_col_var = NULL,
  highlight_box_col_palette = "Heat Colors",
  res_disp_vars = NULL,
  vertex_zoom = 1,
  edge_zoom = 3,
  font_size = 1,
  include_ego = FALSE,
  ...
)

plot_egor(
  x,
  ego_no = 1,
  x_dim = 2,
  y_dim = 2,
  ...,
  type = c("egograph", "egogram")
)

\method{plot}{egor}(x, ...)
}
\arguments{
\item{x}{An \emph{egor} object.}

\item{ego_no}{Ego row number.}

\item{x_dim}{Number of ego networks to plot horizontally.}

\item{y_dim}{Number of ego networks to plot vertically}

\item{venn_var}{Name (character) of alter column.}

\item{pie_var}{Name (character) of alter column.}

\item{vertex_size_var}{Name (\code{character}) of alter column.}

\item{vertex_color_var}{Name (\code{character}) of alter column.}

\item{vertex_color_palette}{Name (\code{character}) of color palette, see details for available color palettes.}

\item{vertex_color_legend_label}{Character.}

\item{vertex_label_var}{Name (\code{character}) of alter column. Set this to \code{NULL} to suppress labels.}

\item{edge_width_var}{Name (\code{character}) of aatie column.}

\item{edge_color_var}{Name (\code{character}) of aatie column.}

\item{edge_color_palette}{Name (\code{character}) of color palette, see details for available color palettes.}

\item{highlight_box_col_var}{Name (\code{character}) of ego column.}

\item{highlight_box_col_palette}{Name (\code{character}) of color palette, see details for available color palettes.}

\item{res_disp_vars}{Name (\code{character}) of ego column.}

\item{vertex_zoom}{Numeric.}

\item{edge_zoom}{Numeric.}

\item{font_size}{Numeric.}

\item{pie_colors}{\code{Character} vector of colors to be used for coloring the
subsections of the circle.}

\item{venn_gradient_reverse}{\code{Logical}, set to TRUE in order to have the color intensity
of venns increase going from the inner circles to the outer circles.}

\item{show_venn_labels}{Logical.}

\item{include_ego}{Logical.}

\item{...}{Additional arguments forwared to plot.igraph.}

\item{ego_alter_edge_width_var}{Name (\code{character}) of alter column.}

\item{ego_alter_edge_color_var}{Name (\code{character}) of alter column.}

\item{type}{Character. Either "egograph" or "egogram".}
}
\description{
\emph{egor} objects can be plotted as \emph{egographs} or \emph{egograms}. By
default networks of the four first egos are plotted.
}
\details{
For type eqals "egograph" ego networks are plotted with \code{igraph}'s
plotting engine. "egogram" uses a special layout that places the nodes
on a map of (1) concentric circles with (2) subsections, that can be mapped to
alter variables.

Available color palettes are:
\itemize{
\item Heat Colors
\item Yellow-Green
\item Red-Yellow
\item Blue-Red
\item Black-White
\item Greys
\item Rainbow
\item Topo Colors
}
}
\section{Functions}{
\itemize{
\item \code{plot_egograms}: Plots an ego-socio-gram.

\item \code{plot_ego_graphs}: Plots an ego graph.
}}

\examples{
e <- make_egor(net.count = 5, max.alters = 12)
plot_egograms(x = e,
              ego_no = 2,
              venn_var = "sex",
              pie_var = "country",
              vertex_size_var = "age")
plot(e)
}
