% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composition.R
\name{composition}
\alias{composition}
\title{Calculate the composition of alter attributes in an \code{egor} object}
\usage{
composition(object, alt.attr, absolute = FALSE)
}
\arguments{
\item{object}{An \code{egor} object.}

\item{alt.attr}{A \code{character} naming the variable containing the alter-attribute.}

\item{absolute}{\code{Logical} indicating if the results should be absolute.}
}
\value{
A \code{tibble} with the ego ID and values per category of \code{alt.attr} as \code{numeric} columns.
}
\description{
\code{composition()} calculates the proportional or absolute composition of
alters for a given attribute/variable.
}
\examples{
data("egor32")
composition(egor32, "sex")
}
\keyword{analysis}
\keyword{ego-centered}
\keyword{network}
