% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.egonet.R
\name{twofiles_to_egor}
\alias{twofiles_to_egor}
\title{Import ego-centered network data from two file format}
\usage{
twofiles_to_egor(
  egos,
  alters,
  ID.vars = list(ego = "egoID", alter = "alterID", source = "Source", target =
    "Target"),
  e.max.alters,
  e.first.var,
  selection = NULL,
  ...
)
}
\arguments{
\item{egos}{\code{Data frame} containing ego data (egos as cases)}

\item{alters}{\code{Data frame} containing alters data (alters in rows),
alters are connected to their ego by an \code{egoID}.}

\item{ID.vars}{A named list containing column names of the relevant
input columns: \describe{

\item{\code{ego}}{unique identifier associated with each ego, defaulting
to \code{"egoID"}; has no effect if \code{alters.df} and \code{aaties.df} are
both lists of data frames.}

\item{\code{alter}}{unique-within-ego identifier associated with each
alter, defaulting to \code{"alterID"}; optional \code{aaties.df} are not
provided.}

\item{\code{source}}{if \code{aaties.df} is provided, the column given the
alter identifier of the origin of a relation.}

\item{\code{target}}{if \code{aaties.df} is provided, the column given the
alter identifier of the destination of a relation.}

}}

\item{e.max.alters}{Maximum number of alters that are included in edge data.}

\item{e.first.var}{Index or name of the first column in \code{egos} containing edge data.}

\item{selection}{\code{Character} naming \code{numeric} variable indicating
alters selection with zeros and ones.}

\item{...}{additional arguments to \code{\link[=egor]{egor()}}.}
}
\value{
An \strong{egor} object is returned. It is a \code{list} of three data frames:
(1) ego: \code{dataframe} of all
egos and their attributes;
(2) alter: \code{dataframe} of all alters;
(3) aatie: \code{dataframe} of alter alter ties/ edges
}
\description{
This function imports ego-centered network data, stored in two files, where
one file contains the ego attributes and the edge information and the other file
contains the alters data. This form of data storage for ego-centered network data
is proposed by Muller, Wellman and Marin (1999).
}
\examples{
path_to_alters_8.csv <- system.file("extdata", "alters_8.csv", package = "egor")
path_to_one_file_8 <- system.file("extdata", "one_file_8.csv", package = "egor")

# read data from disk
egos_8 <- read.csv2(path_to_one_file_8, row.names = 1)
alters_8 <- read.csv2(path_to_alters_8.csv, row.names = 1)

dy.first.var <- which(names(egos_8) == "X1.to.2")

# convert to egor object
  twofiles_to_egor(
    egos = egos_8,
    alters = alters_8,
    e.max.alters = 8,
    e.first.var = dy.first.var)
}
\keyword{import}
