% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustered.graphs.R
\name{vis_clustered_graphs}
\alias{vis_clustered_graphs}
\title{Visualize clustered graphs}
\usage{
vis_clustered_graphs(
  graphs,
  node.size.multiplier = 1,
  node.min.size = 0,
  node.max.size = 200,
  normalise.node.sizes = TRUE,
  edge.width.multiplier = 1,
  center = 1,
  label.size = 0.8,
  labels = FALSE,
  legend.node.size = 45,
  pdf.name = NULL,
  ...
)
}
\arguments{
\item{graphs}{\code{List} of \code{graph} objects, representing the clustered
graphs.}

\item{node.size.multiplier}{\code{Numeric} used to multiply the node diameter
of visualized nodes.}

\item{node.min.size}{\code{Numeric} indicating minimum size of plotted
nodes}

\item{node.max.size}{\code{Numeric} indicating maximum size of plotted
nodes}

\item{normalise.node.sizes}{\code{Logical.} If TRUE (default) node sizes
are plotted using per network proportions rather than counts.}

\item{edge.width.multiplier}{\code{Numeric} used to multiply the edge width.}

\item{center}{\code{Numeric} indicating the vertex to be plotted in center.}

\item{label.size}{\code{Numeric}.}

\item{labels}{\code{Boolean}. Plots with turned off labels will be accompanied
by a 'legend' plot giving the labels of the vertices.}

\item{legend.node.size}{\code{Numeric} used as node diameter of legend graph.}

\item{pdf.name}{\code{Character} giving the name/path of the pdf file to create.}

\item{...}{Arguments to pass to \code{plot.igraph}.}
}
\value{
\code{vis_clustered_graphs} plots
a \code{list} of \code{igraph} objects created by the \code{clustered_graphs}
function.

\code{clustered_graphs} returns a list of graph objects representing
the clustered ego-centered network data;
}
\description{
\code{vis_clustered_graphs} visualizes clustered_graphs using a list of
clustered graphs created with \code{\link{clustered_graphs}}.
}
\examples{
data("egor32")

# Simplify networks to clustered graphs, stored as igraph objects
graphs <- clustered_graphs(egor32, "country") 

# Visualise
par(mfrow = c(2,3))
vis_clustered_graphs(
  graphs[1:5]
)
par(mfrow = c(1,1))
}
\references{
Brandes, U., Lerner, J., Lubbers, M. J., McCarty, C., & Molina,
J. L. (2008). Visual Statistics for Collections of Clustered Graphs. 2008
IEEE Pacific Visualization Symposium, 47-54.
}
\seealso{
\code{\link{clustered_graphs}} for creating clustered graphs objects
}
\keyword{analysis}
\keyword{ego-centered}
\keyword{network}
