% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_models.R
\name{sim_model_ex1}
\alias{sim_model_ex1}
\title{Function for generating functional data in one dimension}
\usage{
sim_model_ex1(n = 50, p = 30, i_sim = 1)
}
\arguments{
\item{n}{Number of curves to generate for each of the two groups.
Set to 50 by default.}

\item{p}{Number of grid points of the curves.
Curves are generated over the interval \eqn{[0, 1]}.
Set to 30 grid point by default.}

\item{i_sim}{Integer set to \eqn{1, \ldots, 8}.}
}
\value{
data matrix of size \eqn{2n \times p}.
}
\description{
Each dataset has 2 groups with \code{n} curves each, defined in the interval
\eqn{t=[0, 1]} with \code{p} equidistant points. The first \code{n} curves are
generated fron the following model
\eqn{X_1(t)=E_1(t)+e(t)} where \eqn{E_1(t)=E_1(X(t))=30t^{ \frac{3}{2}}(1-t)}
is the mean function and \eqn{e(t)} is a centered Gaussian process with
covariance matrix \eqn{Cov(e(t_i),e(t_j))=0.3 \exp(-\frac{\lvert t_i-t_j \rvert}{0.3})}
The remaining 50 functions are generated from model \code{i_sim} with
\code{i_sim} \eqn{\in \{1, \ldots, 8\}.}
The first three models contain changes in the mean, while the covariance
matrix does not change. Model 4 and 5 are obtained by multiplying the
covariance matrix by a constant. Model 6 is obtained from adding to
\eqn{E_1(t)} a centered Gaussian process \eqn{h(t)} whose covariance matrix
is given by \eqn{Cov(e(t_i),e(t_j))=0.5 \exp (-\frac{\lvert t_i-t_j\rvert}{0.2})}.
Model 7 and 8 are obtained by a different mean function.
\describe{
\item{Model 1.}{\eqn{X_1(t)=30t^{\frac{3}{2}}(1-t)+0.5+e(t).}}
\item{Model 2.}{\eqn{X_2(t)=30t^{\frac{3}{2}}(1-t)+0.75+e(t).}}
\item{Model 3.}{\eqn{X_3(t)=30t^{\frac{3}{2}}(1-t)+1+e(t).}}
\item{Model 4.}{\eqn{X_4(t)=30t^{\frac{3}{2}}(1-t)+2 e(t).}}
\item{Model 5.}{\eqn{X_5(t)=30t^{\frac{3}{2}}(1-t)+0.25 e(t).}}
\item{Model 6.}{\eqn{X_6(t)=30t^{\frac{3}{2}}(1-t)+ h(t).}}
\item{Model 7.}{\eqn{X_7(t)=30t{(1-t)}^2+ h(t).}}
\item{Model 8.}{\eqn{X_8(t)=30t{(1-t)}^2+ e(t).}}
}
}
\examples{
sm1 <- sim_model_ex1()
dim(sm1)

}
