% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voter_file_utils.R
\name{tidy_voter_file_wru}
\alias{tidy_voter_file_wru}
\title{Tidies a voter file for WRU.}
\usage{
tidy_voter_file_wru(
  voter_file,
  voter_id = NULL,
  surname = NULL,
  state = NULL,
  county = NULL,
  tract = NULL,
  block = NULL
)
}
\arguments{
\item{voter_file}{The voter file, as a data frame or tibble.}

\item{voter_id}{A string denoting the column containing voter ID. Default is
NULL, when the voter file does not have an ID or registration number.}

\item{surname}{A string denoting the column containing the surname.}

\item{state}{A string denoting the column containing the state FIPS code.}

\item{county}{A string denoting the column containing the county FIPS code.}

\item{tract}{A string denoting the column containing the tract FIPS code.}

\item{block}{A string denoting the column containing the block FIPS code.}
}
\value{
A new voter file that can be read in by WRU functions.
}
\description{
Checks if columns exist in the original voter file and renames them so that
WRU can process the new voter file. Only extract the information needed,
tossing the remaining columns.
}
