% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{incomplete.generator}
\alias{incomplete.generator}
\title{Incomplete data generator}
\usage{
incomplete.generator(m, n, r, snr = 3, prop = 0.5, seed = 1)
}
\arguments{
\item{m}{the rows of the matrix.}

\item{n}{the columns of the matrix.}

\item{r}{the rank of the matrix.}

\item{snr}{the signal-to-noise ratio in generating the matrix. Default \code{snr = 3}.}

\item{prop}{the proportion of missing observations. Default \code{prop = 0.5}.}

\item{seed}{the random seed. Default \code{seed = 1}.}
}
\value{
A matrix with missing values.
}
\description{
Generate a matrix with missing values,
where the indices of missing values are uniformly randomly distributed in the matrix.
}
\details{
We generate the matrix by \eqn{UV + \epsilon}, where \eqn{U}, \eqn{V} are \eqn{m} by \eqn{r}, \eqn{r} by \eqn{n} matrix satisfy standard normal
distribution. \eqn{\epsilon} has a normal distribution with mean 0 and variance \eqn{\frac{r}{snr}}.
}
\examples{
m <- 100
n <- 100
r <- 10
x_na <- incomplete.generator(m, n, r)
head(x_na[, 1:6])
}
