% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_plot.R
\name{wrf_plot}
\alias{wrf_plot}
\title{Simple plot from wrf emission file}
\usage{
wrf_plot(file = file.choose(), name = NA, time = 1, nivel = 1,
  barra = T, lbarra = 0.2, verbose = T, ...)
}
\arguments{
\item{file}{emission file name}

\item{name}{pollutant name}

\item{time}{time from emission file}

\item{nivel}{level from the emission file}

\item{barra}{barblot if TRUE}

\item{lbarra}{length of barplot}

\item{verbose}{if TRUE print some information}

\item{...}{Arguments to be passed to plot methods}
}
\description{
Create a quick plot from wrf emission file
}
\note{
If the file contains levels (kemit>1), and one frame (auxinput5_interval_m = 1)
time with control the level which will be ploted

In case of a error related to plot.new() margins lbarra must be adjusted
}
\examples{
{

dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
          wrfchemi_dir = file.path(tempdir(), "EMISS"))

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS"),
                   pattern = "wrfchemi",
                   full.names = TRUE)

# open, put some numbers and write
wrf_plot(files[1], "E_CO")
}
}
\seealso{
\code{\link{wrf_get}} and \code{\link{wrf_create}}
}
\author{
Daniel Schuch
}
