% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_optimal_t_discrete.R
\name{find_optimal_t_discrete}
\alias{find_optimal_t_discrete}
\title{Finds optimal alignment for discrete open curves}
\usage{
find_optimal_t_discrete(r, p, s, q, initial_t = s, eps = 10^-3)
}
\arguments{
\item{r}{time points for p, first has to be 0, last has to be 1}

\item{p}{square root velocity vectors, one less than time points in r}

\item{s}{time points for q, first has to be 0, last has to be 1}

\item{q}{square root velocity vectors, one less than time points in s}

\item{initial_t}{starting value for the optimisation algorithm}

\item{eps}{convergence tolerance}
}
\value{
optimal time points for q, without first value 0 and last value 1
optimal time points have the distance of the observation to the srv_curve as an attribute
}
\description{
Finds optimal aligned time points for srv curve q to  srv curve p using
coordinate wise optimisation.
}
