% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/connect.R
\name{connect}
\alias{connect}
\alias{connection}
\title{Set connection details to an Elasticsearch engine.}
\usage{
connect(es_base = "http://127.0.0.1", es_port = 9200, es_user = NULL,
  es_pwd = NULL, force = FALSE, ...)

connection()
}
\arguments{
\item{es_base}{The base url, defaults to localhost (http://127.0.0.1)}

\item{es_port}{port to connect to, defaults to 9200 (optional)}

\item{es_user}{User name, if required for the connection. You can specify, but
ignored for now.}

\item{es_pwd}{Password, if required for the connection. You can specify, but
ignored for now.}

\item{force}{Force re-load of connection details}

\item{...}{Further args passed on to print for the es_conn class.}
}
\description{
Set connection details to an Elasticsearch engine.
}
\details{
The default configuration is set up for localhost access on port 9200,
with no username or password.

\code{\link{connection}} does not ping the Elasticsearch server, but only
prints connection details.

On package load, \code{\link{connect}} is run to set the default base url and port.
}
\examples{
\dontrun{
# the default is set to localhost and port 9200
connect()

# or set to a different base url
connect('http://162.243.152.56')

# See connection details
connection()
}
}

