% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_bulk_upload_file}
\alias{create_bulk_upload_file}
\alias{create_bulk_upload_file}
\alias{create_bulk_delete_file}
\title{Create Bulk API data file.}
\usage{
create_bulk_upload_file(metadata, df = NULL)

create_bulk_delete_file(metadata)
}
\arguments{
\item{metadata}{A character vector of Bulk API document information objects, as generated by
\code{create_metadata(...)}.}

\item{df}{[optional] A data.frame with data for indexing or updating.}
}
\value{
The name of the temporary file containing the data for the Elasticsearch Bulk API.
}
\description{
The fastest way to index, delete or update many documents, is via the Bulk API. This function
assembles a text file comprising of data and/or actions in the format required by the Bulk API.
This is ready to be POSTed to the Bulk API.
}
\examples{
\dontrun{
bulk_upload_info <- create_metadata("index", "iris", "data", n = nrow(iris))
create_bulk_upload_file(bulk_upload_info, iris)
# "/var/folders/__/yz_l30s48xj6m_0059b_2twr0000gn/T//RtmpQnvUOt/file98194322b8"

bulk_delete_info <- create_metadata("delete", "iris", "data", n = nrow(iris))
create_bulk_delete_file(bulk_delete_info)
# "/var/folders/__/yz_l30s48xj6m_0059b_2twr0000gn/T//RtmpQnvUOt/file98194322b8"
}
}
\seealso{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-bulk.html}
for more information on the information required by the Elasticsearch Bulk API.
}
