% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legislative_vote.R
\name{legislative_state_vote}
\alias{legislative_state_vote}
\title{Download, clean, and transform data on legislative electoral results by state}
\usage{
legislative_state_vote(year, house = c("chamber", "senate"), prop = TRUE,
  ascii = FALSE, encoding = "Latin-1")
}
\arguments{
\item{year}{Election year (\code{integer}). For this function, only the years 1998, 2002, 2006, 2010, and 2014
are available.}

\item{house}{Report results from which legislative house? Options are \code{senate} and \code{chamber}.}

\item{prop}{Shoud the votes be reported as proportions? (Defaults to \code{TRUE}).}

\item{ascii}{(\code{logical}). Should the text be transformed from Latin-1 to ASCII format?}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}
}
\value{
\code{legislative_state_vote()} returns a \code{tbl, data.frame} with the following variables:.

\itemize{
  \item ANO_ELEICAO: Election year.
  \item SIGLA_UF: Unit of the Federation's acronym in which occurred the election.
  \item SIGLA_PARTIDO: Party acronym.
  \item NOME_PARTIDO: Party name.
  \item NUMERO_PARTIDO: Party number.
  \item NOME_COLIGACAO: Coalition shortname.
  \item COMPOSICAO_LEGENDA: Party's shortname composition.
  \item TOTAL_VOTOS: Party votos (or proportions) votes by state.
}
}
\description{
\code{legislative_state_vote()} downloads, cleans, and transforms data on legislative elections results by
state The electoral results are, by default, reported as proportions.
The user can choose between Senate and Chamber of Deputies electoral results.
}
\examples{
\dontrun{
df <- legislative_state_vote(2002)
}
}
\seealso{
\code{\link{legislative_mun_vote}} for legislative elections results by municipality;
\code{\link{president_mun_vote}} for presidential elections results by municipality;
and \code{\link{president_state_vote}} for presidential elections results by state.
}
