% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-cortex.R
\name{chat_cortex}
\alias{chat_cortex}
\title{Create a chatbot that speaks to the Snowflake Cortex Analyst}
\usage{
chat_cortex(
  account = Sys.getenv("SNOWFLAKE_ACCOUNT"),
  credentials = NULL,
  model_spec = NULL,
  model_file = NULL,
  api_args = list(),
  echo = c("none", "text", "all")
)
}
\arguments{
\item{account}{A Snowflake \href{https://docs.snowflake.com/en/user-guide/admin-account-identifier}{account identifier},
e.g. \code{"testorg-test_account"}.}

\item{credentials}{A list of authentication headers to pass into
\code{\link[httr2:req_headers]{httr2::req_headers()}}, a function that returns them when passed
\code{account} as a parameter, or \code{NULL} to use ambient credentials.}

\item{model_spec}{A semantic model specification, or \code{NULL} when
using \code{model_file} instead.}

\item{model_file}{Path to a semantic model file stored in a Snowflake Stage,
or \code{NULL} when using \code{model_spec} instead.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
Chat with the LLM-powered \href{https://docs.snowflake.com/en/user-guide/snowflake-cortex/cortex-analyst}{Snowflake Cortex Analyst}.

Unlike most comparable model APIs, Cortex does not take a system prompt.
Instead, the caller must provide a "semantic model" describing available
tables, their meaning, and verified queries that can be run against them as a
starting point. The semantic model can be passed as a YAML string or via
reference to an existing file in a Snowflake Stage.

Note that Cortex does not support multi-turn, so it will not remember
previous messages. Nor does it support registering tools, and attempting to
do so will result in an error.
\subsection{Authentication}{

\code{chat_cortex()} picks up the following ambient Snowflake credentials:
\itemize{
\item A static OAuth token defined via the \code{SNOWFLAKE_TOKEN} environment
variable.
\item Key-pair authentication credentials defined via the \code{SNOWFLAKE_USER} and
\code{SNOWFLAKE_PRIVATE_KEY} (which can be a PEM-encoded private key or a path
to one) environment variables.
\item Posit Workbench-managed Snowflake credentials for the corresponding
\code{account}.
}
}
}
\examples{
\dontshow{if (has_credentials("cortex")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_cortex(
  model_file = "@my_db.my_schema.my_stage/model.yaml"
)
chat$chat("What questions can I ask?")
\dontshow{\}) # examplesIf}
}
\seealso{
Other chatbots: 
\code{\link{chat_bedrock}()},
\code{\link{chat_claude}()},
\code{\link{chat_databricks}()},
\code{\link{chat_gemini}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
