% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{Content}
\alias{Content}
\alias{ContentText}
\alias{ContentImage}
\alias{ContentImageRemote}
\alias{ContentImageInline}
\alias{ContentToolRequest}
\alias{ContentToolResult}
\alias{ContentPDF}
\title{Content types received from and sent to a chatbot}
\usage{
Content()

ContentText(text = stop("Required"))

ContentImage()

ContentImageRemote(url = stop("Required"), detail = "")

ContentImageInline(type = stop("Required"), data = NULL)

ContentToolRequest(
  id = stop("Required"),
  name = stop("Required"),
  arguments = list()
)

ContentToolResult(id = stop("Required"), value = NULL, error = NULL)

ContentPDF(type = stop("Required"), data = stop("Required"))
}
\arguments{
\item{text}{A single string.}

\item{url}{URL to a remote image.}

\item{detail}{Not currently used.}

\item{type}{MIME type of the image.}

\item{data}{Base64 encoded image data.}

\item{id}{Tool call id (used to associate a request and a result)}

\item{name}{Function name}

\item{arguments}{Named list of arguments to call the function with.}

\item{value, error}{Either the results of calling the function if
it succeeded, otherwise the error message, as a string. One of
\code{value} and \code{error} will always be \code{NULL}.}
}
\value{
S7 objects that all inherit from \code{Content}
}
\description{
Use these functions if you're writing a package that extends ellmer and need
to customise methods for various types of content. For normal use, see
\code{\link[=content_image_url]{content_image_url()}} and friends.

ellmer abstracts away differences in the way that different \link{Provider}s
represent various types of content, allowing you to more easily write
code that works with any chatbot. This set of classes represents types of
content that can be either sent to and received from a provider:
\itemize{
\item \code{ContentText}: simple text (often in markdown format). This is the only
type of content that can be streamed live as it's received.
\item \code{ContentImageRemote} and \code{ContentImageInline}: images, either as a pointer
to a remote URL or included inline in the object. See
\code{\link[=content_image_file]{content_image_file()}} and friends for convenient ways to construct these
objects.
\item \code{ContentToolRequest}: a request to perform a tool call (sent by the
assistant).
\item \code{ContentToolResult}: the result of calling the tool (sent by the user).
}
}
\examples{
Content()
ContentText("Tell me a joke")
ContentImageRemote("https://www.r-project.org/Rlogo.png")
ContentToolRequest(id = "abc", name = "mean", arguments = list(x = 1:5))
}
