% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{text}
\alias{text}
\title{Add a text body to a message.}
\usage{
text(
  msg,
  content,
  disposition = "inline",
  charset = "utf-8",
  encoding = "7bit",
  interpolate = TRUE,
  .open = "{{",
  .close = "}}",
  .envir = NULL
)
}
\arguments{
\item{msg}{A message object.}

\item{content}{A string of message content.}

\item{disposition}{How content is presented (Content-Disposition).}

\item{charset}{How content is encoded.}

\item{encoding}{How content is transformed to ASCII (Content-Transfer-Encoding).}

\item{interpolate}{Whether or not to interpolate into input using \link[glue]{glue}.}

\item{.open}{The opening delimiter.}

\item{.close}{The closing delimiter.}

\item{.envir}{Environment used for \code{glue} interpolation. Defaults to \code{parent.frame()}.}
}
\value{
A message object.
}
\description{
Uses \code{glue::glue()} to evaluate expressions enclosed in brackets as R code.
}
\examples{
library(magrittr)

msg <- envelope() \%>\% text("Hello!")

# Using {glue} interpolation.
#
name <- "Alice"
msg <- envelope() \%>\% text("Hello {name}.")

print(msg, details = TRUE)

# Disable {glue} interpolation.
#
msg <- envelope() \%>\% text("This is a set: {1, 2, 3}.", interpolate = FALSE)
}
\seealso{
\code{\link{html}}
}
