% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{get_observed_synergies}
\alias{get_observed_synergies}
\title{Load the observed synergies data}
\usage{
get_observed_synergies(file, drug.combinations.tested = NULL)
}
\arguments{
\item{file}{string. The name of the file, can be a full path. See example
below for the format of an observed synergies file.}

\item{drug.combinations.tested}{a character vector with drug combinations
as elements. Default value: NULL.}
}
\value{
a character vector with elements the names of the drug combinations
that were found as synergistic
}
\description{
Use this function to read a file that has the observed synergies data and
output it to a character vector. If \code{drug.combinations.tested}
is NULL (the default), no data validation is done, otherwise we check that
the observed synergies are indeed a subset of the tested drug combinations.
}
\examples{
observed.synergies.file = system.file("extdata", "observed_synergies",
  package = "emba", mustWork = TRUE)
observed.synergies = get_observed_synergies(observed.synergies.file)

}
