% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tsd}
\alias{tsd}
\title{Estimate the parameters that best describe temperature-dependent sex determination}
\usage{
tsd(males = NULL, females = NULL, N = NULL, temperatures = NULL,
  df = NULL, l = 0.05, parameters.initial = c(P = NA, S = -0.5, K = 0),
  males.freq = TRUE, las.x = 1, las.y = 1,
  lab.PT = "Pivotal temperature",
  lab.TRT = paste0("Transitional range of temperatures l=", l * 100, "\%"),
  col.TRT = "gray", col.TRT.CI = rgb(0.8, 0.8, 0.8, 0.5),
  col.PT.CI = rgb(0.8, 0.8, 0.8, 0.5), equation = "logistic",
  replicate = 1000, range.CI = 0.95, print = TRUE, ...)
}
\arguments{
\item{males}{A vector with male numbers}

\item{females}{A vector with female numbers}

\item{N}{A vector with total numbers}

\item{temperatures}{The constant incubation temperatures or any covariate used to fit sex ratio}

\item{df}{A dataframe with at least two columns named males, females or N and temperatures column}

\item{l}{The limit to define TRT (see Girondot, 1999)}

\item{parameters.initial}{Initial values for P, S or K search as a vector, ex. c(P=29, S=-0.3)}

\item{las.x}{las parameter for x axis}

\item{las.y}{las parameter for y axis}

\item{lab.PT}{Label to describe pivotal temperature}

\item{lab.TRT}{Label to describe transitional range of temperature}

\item{males.freq}{Should the graph uses males frequency [TRUE] or females [FALSE]}

\item{equation}{Could be "logistic", "Hill", "Richards" or "GSD"}

\item{replicate}{Number of replicate to estimate SE of TRT}

\item{range.CI}{The range of confidence interval for estimation, default=0.95}

\item{col.TRT}{The color of TRT}

\item{col.TRT.CI}{The color of CI of TRT based on range.CI}

\item{col.PT.CI}{The color of CI of PT based on range.CI}

\item{print}{Do the results must be printed at screen? TRUE or FALSE}

\item{...}{Graphical parameters for plot(), exemple xlab="", ylab="", main=""}
}
\value{
A list the pivotal temperature, transitional range of temperatures and their SE
}
\description{
Estimate the parameters that best describe temperature-dependent sex determination
}
\details{
tsd estimates the parameters that best describe temperature-dependent sex determination
}
\examples{
\dontrun{
CC_AtlanticSW <- subset(STSRE_TSD, RMU=="Atlantic, SW" &
                          Species=="Caretta caretta" & Sexed!=0)
par(mar=c(4,4,5,1)+0.1)
tsdL <- with (CC_AtlanticSW, tsd(males=Males, females=Females,
                                 temperatures=Incubation.temperature-Correction.factor,
                                 equation="logistic"))
tsdH <- with (CC_AtlanticSW, tsd(males=Males, females=Females,
                                 temperatures=Incubation.temperature-Correction.factor,
                                 equation="Hill"))
tsdR <- with (CC_AtlanticSW, tsd(males=Males, females=Females,
                                 temperatures=Incubation.temperature-Correction.factor,
                                 equation="Richards"))
gsd <- with (CC_AtlanticSW, tsd(males=Males, females=Females,
                                 temperatures=Incubation.temperature-Correction.factor,
                                 equation="GSD"))
compare_AIC(Logistic_Model=tsdL, Hill_model=tsdH, Richards_model=tsdR, GSD_model=gsd)
}
}
\author{
Marc Girondot
}
\references{
Girondot, M. 1999. Statistical description of temperature-dependent sex determination using maximum likelihood. Evolutionary Ecology Research, 1, 479-486.

Godfrey, M.H., Delmas, V., Girondot, M., 2003. Assessment of patterns of temperature-dependent sex determination using maximum likelihood model selection. Ecoscience 10, 265-272.

Hulin, V., Delmas, V., Girondot, M., Godfrey, M.H., Guillon, J.-M., 2009. Temperature-dependent sex determination and global change: are some species at greater risk? Oecologia 160, 493-506.
}

