% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_methods.R
\name{getGroupsFormula}
\alias{getGroupsFormula}
\alias{getGroupsFormula.direct}
\alias{getGroupsFormula.ebp}
\alias{getGroupsFormula.fh}
\title{Extract Grouping Formula from an emdi Object}
\usage{
\method{getGroupsFormula}{direct}(object, ...)

\method{getGroupsFormula}{ebp}(object, ...)

\method{getGroupsFormula}{fh}(object, ...)
}
\arguments{
\item{object}{an object of type "emdi", depending on the method either
"direct", "ebp" or "fh".}

\item{...}{additional arguments that are not used in this method.}
}
\value{
A one-sided formula.
}
\description{
Methods \code{getGroupsFormula.direct}, \code{getGroupsFormula.ebp} and
\code{getGroupsFormula.fh} extract the grouping formula from an
emdi object.
}
\details{
The generic function \code{getGroupsFormula} is imported from
package nlme and re-exported to make the S3-methods available, even though
the nlme package itself is not loaded or attached. For default documentation,
see \code{\link[nlme]{getGroupsFormula}}.
}
\examples{
\donttest{
# Example for class ebp
emdi_model <- ebp(
  fixed = eqIncome ~ gender + eqsize + cash + self_empl +
    unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + fam_allow +
    house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
  pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
  na.rm = TRUE
)

getGroupsFormula(emdi_model)
}
}
\seealso{
\code{\link{direct}}, \code{\link{ebp}},
\code{\link{fh}}, \code{\link[nlme]{getGroupsFormula}}
}
