% Generated by roxygen2 (4.0.1): do not edit by hand
\name{trace.msg}
\alias{trace.msg}
\title{Print a timestamped and indented log message}
\usage{
trace.msg(level = 1, ..., time = TRUE, linebreak = TRUE, file = "")
}
\arguments{
\item{level}{Indentation level.}

\item{...}{Sent to \code{\link{sprintf}}.}

\item{time}{Whether or not to print timestamp.}

\item{linebreak}{Whether to finish the message with a linebreak or not.}

\item{file}{Sent to \code{\link{cat}}.}
}
\description{
Print a timestamped and indented log message
}
\examples{
equipment <- c("flashlight", "snacks", "pick")
{
    trace.msg(1, "Begin descent")
    trace.msg(2, "Oh no, forgot the \%s!", sample(equipment, 1))
    trace.msg(2, "Hello? Can you throw it down to me?", time=FALSE)
    trace.msg(1, "Aw shucks, I'm coming back up.")
}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

