% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/survival.r
\name{dichotomize}
\alias{dichotomize}
\title{Dichotomize time-to-event data}
\usage{
dichotomize(x, time, to_factor)
}
\arguments{
\item{x}{\code{\link{Surv}} vector.}

\item{time}{Time point to dichotomize at.}

\item{to_factor}{Depending on the type of \code{x} the return value may be
integer or factor. Set this argument to explicitly state the return type.}
}
\value{
Integer vector or factor.
}
\description{
Convert time-to-event data (typically created with the \code{\link{Surv}}
function) to factor or integer.
}
\details{
If no time point is given the observation times will be stripped, leaving
only the event types. If a time point is given
observations with events occurring before \code{time} will be labelled by
their event type,
observations with events occurring after \code{time} will be labelled as
\dQuote{no event}, and
observations censored before \code{time} will be considered as missing
information.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{Surv}}
}

