% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pamr.r
\name{fit_pamr}
\alias{fit_pamr}
\title{Fit nearest shrunken centroids model.}
\usage{
fit_pamr(x, y, error_fun, cv, nfold, threshold = NULL, ...,
  thres_fun = function(thr, err) median(thr[err == min(err)]), slim = FALSE)
}
\arguments{
\item{x}{Dataset, numerical matrix with observations as rows.}

\item{y}{Class labels, factor.}

\item{error_fun}{Error function for tuning.}

\item{cv}{Cross-validation scheme for shrinkage tuning. It should
be supplied on one of the following forms:
\itemize{
  \item{Resampling scheme produced with \code{\link{resample}}
    or \code{\link{resample_holdout}}.}
  \item{List with elements named \code{nrepeat} and \code{nfold}}
  \item{\code{NA}, \code{NULL} or \code{FALSE} to suppress shrinkage tuning.}
}}

\item{nfold}{Sent to \code{\link[pamr]{pamr.cv}}. Only used if \code{cv} is missing.}

\item{threshold}{Shrinkage thresholds to try (referred to as 'lambda' in the
literature). Chosen and tuned automatically by default, but must be given
by the user if not tuned (see the \code{cv} argument) if you wish to use
it with \code{\link{evaluate}}.}

\item{...}{Sent to \code{\link[pamr]{pamr.train}}.}

\item{thres_fun}{Threshold selection function. Note that it is not uncommon
that several thresholds will result in the same tuning error.}

\item{slim}{Set to \code{TRUE} if you want to return the fitted
classifier but discard pamr's \code{cv.objects}, which can be large.
memory efficient. This means that the element \code{cv$cv.objects} 
containing the cross-validated fits will be dropped from the returned
classifier.}
}
\value{
Fitted pamr classifier.
}
\description{
Wrapped version of the \pkg{pamr} package implementation. Note that
this function uses internal cross-validation for determining the value
of the shrinkage threshold.
}
\seealso{
\code{\link{emil}}, \code{\link{predict_pamr}},
  \code{\link{importance_pamr}}, \code{\link{modeling_procedure}}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
