% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmGrid-methods.R
\docType{data}
\name{update.emmGrid}
\alias{update.emmGrid}
\alias{emm_options}
\alias{get_emm_option}
\alias{emm_defaults}
\title{Set or retrieve options for objects and summaries}
\format{An object of class \code{list} of length 13.}
\usage{
\method{update}{emmGrid}(object, ..., silent = FALSE)

emm_options(...)

get_emm_option(x, default = emm_defaults[[x]])

emm_defaults
}
\arguments{
\item{object}{An \code{emmGrid} object}

\item{...}{Options to be set. These must match a list of known options (see
Details)}

\item{silent}{Logical value. If \code{FALSE} (the default), a message is
displayed if any options are not matched. If \code{TRUE}, no messages are
shown.}

\item{x}{Character value - the name of an option to be queried}

\item{default}{Value to return if \code{x} is not found}
}
\value{
\code{update.emmGrid} returns an updated \code{emmGrid} object.

\code{emm_options} returns the current options (same as the result 
  of \samp{getOption("emmeans")}) -- invisibly, unless called with no arguments.

\code{get_emm_option} returns the currently stored option for \code{x}, 
  or its default value if not found.
}
\description{
Objects of class \code{emmGrid} contain several settings that affect primarily 
the defaults used by \code{\link{summary.emmGrid}}. This \code{update} method allows
them to be changed more safely than by modifying this slot directly.
In addition, the user may set or retrieve defaults for these settings.
}
\section{Details for \code{update.emmGrid}}{

In \code{update}, the names in \code{\dots} are partially matched against those that are valid, and if a match is found, it adds or replaces the current setting. The valid names are

\describe{
\item{\code{tran}, \code{tran2}}{(\code{list} or \code{character}) specifies
the transformation which, when inverted, determines the results displayed by
\code{\link{summary.emmGrid}}, \code{\link{predict.emmGrid}}, or \code{\link{emmip}} when
\code{type="response"}. The value may be the name of a standard
transformation from \code{\link{make.link}} or additional ones supported by
name, such as \code{"log2"}; or, for a custom transformation, a \code{list}
containing at least the functions \code{linkinv} (the inverse of the
transformation) and \code{mu.eta} (the derivative thereof). The
\code{\link{make.tran}} function returns such lists for a number of popular
transformations. See the help page of \code{\link{make.tran}} for details as
well as information on the additional named transformations that are
supported. \code{tran2} is just like \code{tran} except it is a second
transformation (i.e., a response transformation in a generalized linear
model).}

\item{\code{tran.mult}}{Multiple for \code{tran}. For example, for the
response transformation \samp{2*sqrt(y)} (or \samp{sqrt(y) + sqrt(y + 1)},
for that matter), we should have \code{tran = "sqrt"} and \code{tran.mult =
2}. If absent, a multiple of 1 is assumed.}

\item{\code{estName}}{(\code{character}) is the column label used for
displaying predictions or EMMs.}

\item{\code{inv.lbl}}{(\code{character)}) is the column label to use for
predictions or EMMs when \code{type="response"}.}

\item{\code{by.vars}}{(\code{character)} vector or \code{NULL}) the variables
used for grouping in the summary, and also for defining subfamilies in a call
to \code{\link{contrast}}.}

\item{\code{pri.vars}}{(\code{character} vector) are the names of the grid
variables that are not in \code{by.vars}. Thus, the combinations of their
levels are used as columns in each table produced by \code{\link{summary.emmGrid}}.}

\item{\code{alpha}}{(numeric) is the default significance level for tests, in
\code{\link{summary.emmGrid}} as well as \code{\link{cld.emmGrid}} and \code{\link{plot.emmGrid}}
when \samp{intervals = TRUE}}

\item{\code{adjust}}{(\code{character)}) is the default for the \code{adjust}
argument in \code{\link{summary.emmGrid}}.}

\item{\code{estType}}{(\code{character}) is the type of the estimate. It
should match one of \samp{c("prediction", "contrast", "pairs")}. This is used
along with \code{"adjust"} to determine appropriate adjustments to P values
and confidence intervals.}

\item{\code{famSize}}{(integer) is the \code{nmeans} parameter for
\code{\link{ptukey}} when \code{adjust="tukey"}. }

\item{\code{infer}}{(\code{logical} vector of length 2) is the default value
of \code{infer} in \code{\link{summary.emmGrid}}.}

\item{\code{level}}{(numeric) is the default confidence level, \code{level},
in \code{\link{summary.emmGrid}}}

\item{\code{df}}{(numeric) overrides the default degrees of freedom with a
specified single value.}

\item{\code{null}}{(numeric) null hypothesis for \code{summary} or
\code{test} (taken to be zero if missing).}

\item{\code{side}}{(numeric or character) \code{side} specification for for
\code{summary} or \code{test} (taken to be zero if missing).}

\item{\code{delta}}{(numeric) \code{delta} specification for \code{summary}
or \code{test} (taken to be zero if missing).}

\item{\code{predict.type} or \code{type}}{(character) sets the default method
of displaying predictions in \code{\link{summary.emmGrid}},
\code{\link{predict.emmGrid}}, and \code{\link{emmip}}. Valid values are
\code{"link"} (with synonyms \code{"lp"} and \code{"linear"}), or
\code{"response"}.}

\item{\code{avgd.over}}{(\code{character)} vector) are the names of the 
variables whose levels are averaged over in obtaining marginal averages of 
predictions, i.e., estimated marginal means. Changing this might produce a 
misleading printout, but setting it to \code{character(0)} will suppress the 
\dQuote{averaged over} message in the summary.}

\item{\code{initMesg}}{(\code{character}) is a string that is added to the
beginning of any annotations that appear below the \code{\link{summary.emmGrid}}
display.}

\item{\code{methDesc}}{(\code{character}) is a string that may be used for
creating names for a list of \code{emmGrid} objects. }

\item{\code{nesting}}{(Character or named \code{list}) specifies the nesting
structure. See \dQuote{Recovering or overriding model information} in the
documentation for \code{\link{ref_grid}}. The current nesting structure is
displayed by \code{\link{str.emmGrid}}.}

\item{(any slot name)}{If the name matches an element of
\code{slotNames(object)}, that slot is replaced by the supplied value, if it
is of the required class (otherwise an error occurs). Note that other options
above are saved in the \code{misc} slot; hence, you probably
don't want to replace that slot. The user must be very careful in
replacing slots because they are interrelated; for example, the \code{levels}
and \code{grid} slots must involve the same variable names, and the lengths
and dimensions of \code{grid}, \code{linfct}, \code{bhat}, and \code{V} must
conform.}
} %%%%%%% end \describe
}

\section{Using \code{emm_options}}{

In \code{emm_options}, we may set or change the \emph{default} values for the
above options. These defaults are set separately for different contexts in
which \code{emmGrid} objects are created, in a named list of option lists.
Currently, the following main list entries are supported:
\describe{
\item{\code{ref_grid}}{A named \code{list} of defaults for objects created by
\code{\link{ref_grid}}. This could affect other objects as well. For example,
if \code{emmeans} is called with a fitted model object, it calls
\code{ref_grid} and this option will affect the resulting \code{emmGrid}
object.}
\item{\code{emmeans}}{A named \code{list} of defaults for objects created by
  \code{\link{emmeans}} or \code{\link{emtrends}}.}
\item{\code{contrast}}{A named \code{list} of defaults for objects created by
  \code{\link{contrast.emmGrid}} or \code{\link{pairs.emmGrid}}.}
\item{\code{summary}}{A named \code{list} of defaults used by the methods
  \code{\link{summary.emmGrid}}, \code{\link{predict.emmGrid}}, \code{\link{test.emmGrid}},
  \code{\link{confint.emmGrid}}, and \code{\link{emmip}}. The only option that can
  affect the latter four is \code{"predict.method"}.}
\item{\code{graphics.engine}}{A character value matching 
  \code{c("ggplot", "lattice")}, setting the default engine to use in
  \code{\link{emmip}} and \code{\link{plot.emmGrid}}.  Defaults to \code{"ggplot"}.}
% \item{\code{msg.data.call}}{Logical value controlling whether or not
%   a warning is displayed when a model's \code{data} or \code{subset}
%   component contains a call. This can be hazardous; for example, if a model
%   call contains something like \code{subset = sample(...)}, then that same
%   call to \code{sample} will be run again when the reference grid is
%   constructed -- but it will be a different subset! This will definitely
%   affect the covariate settings, and may even affect the factor levels.
%   Defaults to \code{TRUE}.} 
\item{\code{msg.interaction}}{A logical value controlling whether or not
  a message is displayed when \code{emmeans} averages over a factor involved
  in an interaction. It is probably not appropriate to do this, unless
  the interaction is weak. Defaults to \code{TRUE}.}
\item{\code{msg.nesting}}{A logical value controlling whether or not to
  display a message when a nesting structure is auto-detected. The existence
  of such a structure affects computations of EMMs. Sometimes, a nesting
  structure is falsely detected -- namely when a user has omitted some
  main effects but included them in interactions. This does not change the
  model fit, but it produces a different parameterization that is picked
  up when the reference grid is constructed. Defaults to \code{TRUE}.}
}%%% end describe{}
Some other options have more specific purposes:
\describe{
\item{\code{estble.tol}}{Tolerance for determining estimability in
rank-deficient cases. If absent, the value in \code{emm_defaults$estble.tol)}
is used.}
\item{\code{save.ref_grid}}{Logical value of \code{TRUE} if you wish the 
latest reference grid created to be saved in \code{.Last.ref_grid}}
\item{Options for \code{lme4::lmerMod} models}{Options \code{lmer.df},
\code{disable.pbkrtest}, \code{pbkrtest.limit}, \code{disable.lmerTest},
and \code{lmerTest.limit}
options affect how degrees of freedom are computed for \code{lmerMod} objects
produced by the \pkg{lme4} package). See that section of the "models" vignette
for details.}
} %%%%%% end \describe
}

\examples{
# Using an already-transformed response:
mypigs <- transform(pigs, logconc = log(pigs$conc))
mypigs.lm <- lm(logconc ~ source + factor(percent), data = mypigs)

# Reference grid that knows about the transformation:
mypigs.rg <- update(ref_grid(mypigs.lm), tran = "log", 
                    predict.type = "response")
emmeans(mypigs.rg, "source")
\dontrun{
emm_options(ref_grid = list(level = .90),
            contrast = list(infer = c(TRUE,FALSE)),
            estble.tol = 1e-6)
# Sets default confidence level to .90 for objects created by ref.grid
# AS WELL AS emmeans called with a model object (since it creates a 
# reference grid). In addition, when we call 'contrast', 'pairs', etc.,
# confidence intervals rather than tests are displayed by default.
}

\dontrun{
emm_options(disable.pbkrtest = TRUE)
# This forces use of asymptotic methods for lmerMod objects.
# Set to FALSE or NULL to re-enable using pbkrtest.
}

# See tolerance being used for determining estimability
get_emm_option("estble.tol")

}
\keyword{datasets}
