% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPerformance.R
\name{survPerformance}
\alias{survPerformance}
\alias{R2sh}
\alias{R2pm}
\alias{cal.Slope}
\title{Survival models performance analysis}
\usage{
R2sh(time, status, lin.pred, data, R)

R2pm(lin.pred, R)

cal.Slope(time, status, lin.pred, R)
}
\arguments{
\item{time}{A vector of event times.}

\item{status}{A indicator vector of event occurrence.}

\item{lin.pred}{A vector of linear predictors of a survival model for each observation. (prognostic index)}

\item{data}{A data.frame where to find column vectors.}

\item{R}{The number of bootstrap replicates. Usually this will be a single positive integer. For importance resampling, some resamples may use one set of weights and others use a different set of weights. In this case R would be a vector of integers where each component gives the number of resamples from each of the rows of weights. To be passed to \code{\link[boot]{boot}}.}
}
\value{
\code{R2sh} returns a list with the following components:
\itemize{
\item \code{D}: The estimator of predictive accuracy obtained from the covariate-free null model.
\item \code{Dx}: The estimator of predictive accuracy obtained from the Cox model.
\item \code{V}: The estimator of relative gains in predictive accuracy.
\item \code{Mhat}: The absolute distance estimator obtained from the   Cox model (evaluated at the event times of the test data).
\item \code{Mhat.0}: The absolute distance estimator obtained from the covariate-free null model (evaluated at the event times of the test data).
\item \code{timep}: The event times of the test data.
\item \code{lower}: V lower confidence limit.
\item \code{upper}: V upper confidence limit.
\item \code{boot}: An object of class "\code{\link[boot]{boot}}".
\item \code{bootCI}: Boot confidence intervals resampling.
}

\code{R2pm} returns a list with the following components:
\itemize{
\item \code{r2}: The estimator of predictive accuracy obtained from the Cox model.
\item \code{lower}: r2 lower confidence limit.
\item \code{upper}: r2 upper confidence limit.
\item \code{boot}: An object of class "\code{\link[boot]{boot}}".
\item \code{bootCI}: Boot confidence intervals resampling.
}

\code{cal.Slope} returns a list with the following components:
\itemize{
\item \code{slope}: The calibration slope measure of a survival model.
\item \code{lower}: slope lower confidence limit.
\item \code{upper}: slope upper confidence limit.
\item \code{boot}: An object of class "\code{\link[boot]{boot}}".
\item \code{bootCI}: Boot confidence intervals resampling.
}
}
\description{
Colection of functions for survival models performance analysis.

\code{R2sh} estimates a distance-based estimator of survival predictive accuracy proposed by Schemper and Henderson. It was inspirated in survAUC::schemper function, but receives the predicted values directly. Besides that, \code{R2sh} does bootstrap resampling and returns its confidence interval estimate.


\code{R2pm} calculates a estimator of survival predictive accuracy proposed by Kent & O'Quigley and its bootstrap confidence interval.


\code{cal.Slope} returns the calibration slope of a survival model and its bootstrap confidence interval.
}
\examples{

#### Survival model ####

data(breastCancer)
class(breastCancer$gradd1) <- "character"
class(breastCancer$gradd2) <- "character"

traindata <- breastCancer[sample(nrow(breastCancer), nrow(breastCancer)*2/3),]
newdata <- breastCancer[-sample(nrow(breastCancer), nrow(breastCancer)*2/3),]
model <- rms::cph(survival::Surv(rectime, censrec) ~ rms::rcs(age,6) +
 rms::rcs(nodes,3) + rms::rcs(pgr,3) + gradd1 + gradd2 +
 hormon, data = traindata)

lp <- predict(model, newdata = newdata)

#### R2sh  example ####

R2sh(newdata$rectime, newdata$censrec, lp, data = newdata, R = 50)

#### R2pm example ####

R2pm(lp, R = 50)

#### cal.slope example ####

cal.Slope(newdata$rectime, newdata$censrec, lp, R = 50)

}
\references{
Schemper, M. and R. Henderson (2000).
Predictive accuracy and explained variation in Cox regression.
Biometrics 56, 249-255.

Davison, A.C. and Hinkley, D.V. (1997) Bootstrap Methods and Their Application, Chapter 5. Cambridge University Press.

DiCiccio, T.J. and Efron B. (1996) Bootstrap confidence intervals (with Discussion). Statistical Science, 11, 189-228.

Efron, B. (1987) Better bootstrap confidence intervals (with Discussion). Journal of the American Statistical Association, 82, 171-200.

Kent, John T., and J. O. H. N. O'QUIGLEY. "Measures of dependence for censored survival data." Biometrika 75.3 (1988): 525-534.

van Houwelingen, Hans C. "Validation, calibration, revision and combination of prognostic survival models." Statistics in medicine 19.24 (2000): 3401-3415.

Rahman, M. Shafiqur, et al. "Review and evaluation of performance measures for survival prediction models in external validation settings." BMC medical research methodology 17.1 (2017): 60.
}
\author{
Lunna Borges <lunna.borges@epimedsolutions.com>
}
