% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackdata.class.R
\name{plot.trackdata}
\alias{plot.trackdata}
\title{Produces time-series plots from trackdata}
\usage{
\method{plot}{trackdata}(x, timestart = NULL, xlim = NULL,
  ylim = NULL, labels = NULL, col = TRUE, lty = FALSE,
  type = "p", pch = NULL, contig = TRUE, ...)
}
\arguments{
\item{x}{A trackdata object.}

\item{timestart}{A single valued numeric vector for setting the time at
which the trackdata should start. Defaults to NULL which means that the
start time is taken from start(trackdata), i.e. the time at which the
trackdata object starts.}

\item{xlim}{A numeric vector of two values for specifying the time interval
over which the trackdata is to be plotted. Defaults to NULL which means
that the trackdata object is plotted between between the start time of the
first segment and the end time of the last segment.}

\item{ylim}{Specify a yaxis range.}

\item{labels}{A character vector the same length as the number of segments
in the trackdata object. Each label is plotted at side = 3 on the plotted
at the temporal midpoint of each segment in the trackdata object. Defaults
to NULL (plot no labels). Labels will only be plotted if xlim=NULL.}

\item{col}{A single element logical vector. Defaults to T to plot each
label type in a different colour}

\item{lty}{A single element logical vector. Defaults to F.  If TRUE, plot
each label type in a different linetype}

\item{type}{Specify the type of plot. See \link{plot} for the various
possibilities}

\item{pch}{The symbol types to be used for plotting. Should be specified as
a numeric vector of the same length as there are unique label classes}

\item{contig}{A single valued logical vector T or F. If T, then all the
segments of the trackdata object are assumed to be temporally contiguous,
i.e. the boundaries of the segments are abutting in time and the start time
of segment[j,] is the end time of segment[j-1,]. In this case, all the
segments of the trackdata object are plotted on the same plot as a function
of time. An example of a contiguous trackdata object is coutts.sam. contig
= FALSE is when a trackdata object is non-contiguous e.g. all "i:" vowels
in a database. An example of a non-contiguous trackdata object is
vowlax.fdat. If contig=F then each segment of the trackdata object is
plotted separately.}

\item{...}{the same graphical parameters can be supplied to this function
as for plot e.g type="l", lty=2 etc.}
}
\description{
The function produces a plot as a function of time for a single segment or
multiple plots as a function of time for several segments.
}
\details{
The function plots a single segment of trackdata as a function of time. If
the segment contains multiple tracks, then these will be overlaid. If there
are several temporally non-contiguous segments in the trackdata object,
each segment is plotted in a different panel by specifying contig=F. This
function is not suitable for overlaying trackdata from more than one
segments on the same plot as a function of time: for this use dplot().
}
\examples{


# a single segment of trackdata (F1) plotted as a function of time.
plot(vowlax.fdat[1,1])

# as above, but limits are set for the time axis.
plot(vowlax.fdat[1,1], xlim=c(880, 920))

# the the start-time of the x-axis is set to 0 ms, plot F1 and F3, lineplot
plot(vowlax.fdat[1,c(1,3)],  timestart=0, type="l")


# plot F1-F4, same colour, same plotting symbol, between 900 
# and 920 ms, type is line and points plot, different linetype per track, no box
plot(vowlax.fdat[1,], col="blue", pch=20, xlim=c(900, 920), type="b", lty=TRUE, bty="n")


# F1 and F2 of six vowels with labels, separate windows
par(mfrow=c(2,3))
plot(vowlax.fdat[1:6,1:2], contig=FALSE, labels=vowlax.l[1:6], ylab="F1 and F2", 
xlab="Time (ms)", type="b", ylim=c(300, 2400))

# As above, timestart set to zero, colour set to blue, different plotting
# symbols for the two tracks
plot(vowlax.fdat[1:6,1:2], contig=FALSE, labels=vowlax.l[1:6], ylab="F1 and F2", 
xlab="Time (ms)", type="b", col="blue", pch=c(1,2),  ylim=c(300, 2400), timestart=0)

# RMS energy for the utterance 'just relax said Coutts'
 plot(coutts.rms, type="l")
# as above a different colour
 plot(coutts.rms, type="l", col="pink")
# as above, linetype 2, double line thickness, no box, times reset to 0 ms
 plot(coutts.rms, type="l", col="pink", lty=2, lwd=2, bty="n", timestart=0)
# as above but plotted as non-contiguous segments, i.e one segment per panel
 par(mfrow=c(2,3))
 plot(coutts.rms, type="l", col="pink", lty=2, lwd=2, bty="n", timestart=0, contig=FALSE)
# plot with labels
 labels = label(coutts)
par(mfrow=c(1,1))
 plot(coutts.rms, labels=labels, type="l", bty="n")
# as above, double line-thickness, green, line type 3, no box, 
# time start 0 ms with x and y axis labels
 plot(coutts.rms, labels=labels, type="l", lwd=2, 
      col="green", lty=3,  bty="n", timestart=0, xlab="Time (ms)", ylab="Amplitude")
# as above with a different plotting symbol for the points
par(mfrow=c(2,3))
 plot(coutts.rms, labels=labels, type="b", lwd=2, col="green", 
      timestart=0, bty="n", contig=FALSE, pch=20)
 


}
\seealso{
\code{\link{plot}}, \code{\link{dplot}}
}
\author{
Jonathan Harrington
}
\keyword{dplot}
