% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force.balance.R
\name{force.balance}
\alias{force.balance}
\title{force.balance --- repeatedly applies balance until 
sub-tolerance is reached
INPUT = network model
OUTPUT = balanced model
M. Lau 1 Oct 2012
---------------------------------------------------
force.balance --- repeatedly applies balance until sub-tolerance is reached
INPUT = network model OUTPUT = balanced model M. Lau 1 Oct 2012
--------------------------------------------------- force.balance ---
repeatedly applies balance until sub-tolerance is reached INPUT = network
model OUTPUT = balanced model M. Lau 1 Oct 2012
--------------------------------------------------- Repeated Application the
Balance Function}
\usage{
force.balance(x, tol = 5, max.itr = 10, method = "AVG2")
}
\arguments{
\item{x}{A network object.}

\item{tol}{Percent error tolerance for difference between inputs and
outputs.}

\item{max.itr}{Maximum number iterations.}

\item{method}{The balancing method to use, see balance. DEFAULT = AVG2.}
}
\value{
Returns a balanced network model.
}
\description{
This function repeatedly balances a model, sequentially with the output
being passed back to the balance function, until it is within tolerance or
the maximum number of iterations is reached.
}
\examples{



data(troModels)
ssCheck(troModels[[1]])
fb.model = force.balance(troModels[[2]])  #produces a balanced model



}
\references{
Allesina, S., Bondavalli, C., 2003.Steady state of ecosystem
flow networks: a comparison between balancing procedures.Ecological
Modelling 165(2-3):231-239.
}
\seealso{
\code{\link{balance}}
}
\author{
Matthew K. Lau Stuart R. Borrett
}
