% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pln.R
\name{pln}
\alias{pln}
\title{Poisson Lognormal Model}
\usage{
pln(
  form,
  data = NULL,
  par = NULL,
  method = "BFGS",
  init = c("zero", "unif", "norm", "default")[4],
  H = 20,
  verbose = 0,
  accu = 10000
)
}
\arguments{
\item{form}{Formula}

\item{data}{Input data, a data frame}

\item{par}{Starting values for estimates}

\item{method}{Optimization algorithm.}

\item{init}{Initialization method}

\item{H}{Number of quadrature points}

\item{verbose}{Level of output during estimation. Lowest is 0.}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate a Poisson model with a log-normally distributed heterogeneity term. Also referred to as Poisson-Normal model.
}
\examples{
library(MASS)
N = 2000
set.seed(1)

# Works well when the variance of the normal term is not overly large
# When the variance is very large, it tends to be underestimated
x = rbinom(N, 1, 0.5)
z = rnorm(N)
y = rpois(N, exp(-1 + x + z + 0.5 * rnorm(N)))
est = pln(y~x+z)
est$estimates
}
\references{
Peng, Jing. (2022) Identification of Causal Mechanisms from Randomized Experiments: A Framework for Endogenous Mediation Analysis. Information Systems Research (Forthcoming), Available at SSRN: https://ssrn.com/abstract=3494856
}
