% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioticVelocity.r
\name{.interpCoordFromQuantile}
\alias{.interpCoordFromQuantile}
\title{Latitude of quantile(s) of the geographic abundance distribution}
\usage{
.interpCoordFromQuantile(
  latOrLong,
  quants,
  x,
  coordVect,
  weightedElev = NULL,
  warn = TRUE
)
}
\arguments{
\item{latOrLong}{Either 'latitude' or 'longitude'}

\item{quants}{Quantile value(s) (i.e., in the range [0, 1])}

\item{x}{Matrix of abundances.}

\item{coordVect}{Vector of latitudes, one per row in \code{x} (from south to north!!!) **OR** vector or longitudes, one per column in \code{x} (from west to east!!!).}

\item{weightedElev}{Raster of elevations weighted by x1 or x2 or \code{NULL}.}

\item{warn}{Logical. Show warnings.}
}
\description{
This function returns the latitude or longitude of quantile(s) of the geographic abundance distribution. The input is derived from a rasterized map of the species abundance distribution. If a quantile would occur somewhere between two cells, the latitude/longitude is linearly interpolated between the cells bracketing its value.
}
\keyword{internal}
