% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se.R
\name{se}
\alias{se}
\alias{CI}
\title{Standard error and confidence interval}
\usage{
se(x, na.rm = FALSE)

CI(x, level = 0.95, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector or an \R object which is coercible to one by
\code{as.vector(x, "numeric")}.}

\item{na.rm}{logical. Should missing values be removed?}

\item{level}{the confidence level required.}
}
\description{
This wrapper function computes the standard error (SE) or the confidence
interval (CI) of the values in \code{x}. If \code{na.rm} is \code{TRUE},
missing values are removed before the computation proceeds.
}
\examples{
se(1:5)
CI(1:5)

}
\seealso{
\code{\link[stats]{sd}} for the standard deviation.
}
