% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recplot2.R
\name{enve.recplot2.compareIdentities}
\alias{enve.recplot2.compareIdentities}
\title{Enveomics: Recruitment Plot (2) Compare Identities}
\usage{
enve.recplot2.compareIdentities(x, y, method = "hellinger",
  smooth.par = NULL, pseudocounts = 0, max.deviation = 0.75)
}
\arguments{
\item{x}{First \code{\link{enve.RecPlot2}} object.}

\item{y}{Second \code{\link{enve.RecPlot2}} object.}

\item{method}{Distance method to use. This should be (an unambiguous abbreviation of)
one of:
\itemize{
   \item{"hellinger" (\emph{Hellinger, 1090, doi:10.1515/crll.1909.136.210}),}
   \item{"bhattacharyya" (\emph{Bhattacharyya, 1943, Bull. Calcutta Math. Soc. 35}),}
   \item{"kl" or "kullback-leibler" (\emph{Kullback & Leibler, 1951,
   doi:10.1214/aoms/1177729694}), or}
   \item{"euclidean"}
}}

\item{smooth.par}{Smoothing parameter for cubic spline smoothing. Use 0 for no smoothing.
Use \code{NULL} to automatically determine this value using leave-one-out
cross-validation (see \code{smooth.spline} parameter \code{spar}).}

\item{pseudocounts}{Smoothing parameter for Laplace smoothing. Use 0 for no smoothing, or
1 for add-one smoothing.}

\item{max.deviation}{Maximum mean deviation between identity breaks tolerated (as percent
identity). Difference in number of \code{id.breaks} is never tolerated.}
}
\description{
Compare the distribution of identities between two \code{\link{enve.RecPlot2}} 
objects.
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
