% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{standardize_env_name}
\alias{standardize_env_name}
\title{Standardize the name of a named environment}
\usage{
standardize_env_name(env_name)
}
\arguments{
\item{env_name}{environment name to standardize.}
}
\value{
Standardized name of the environment. If the environment is NOT a named
environment and it does not contain an expression that resolves to a named environment
it returns the input name as is. This includes strings that represent non-existing objects.
}
\description{
This function standardizes the name of a named environment so it is consistent
with the output of the base function \link{environmentName}.
For instance \code{globalenv()}, \code{.GlobalEnv} becomes \code{"R_GlobalEnv"}
\code{emptyenv()} becomes \code{"R_EmptyEnv"}
\code{baseenv()} or \code{as.environment("package:base")} becomes \code{"base"}.
All other named environments such as packages and namespaces are also converted
to the standard name used by R.
}
\keyword{internal}
