% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{grubbs.test}
\alias{grubbs.test}
\title{Outlier detection using Grubbs test - Only intended for developer use}
\usage{
grubbs.test(x, alpha = 0.05)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{alpha}{a numeric value giving test significance level.}
}
\value{
A list is returned with elements:
\item{result}{A table containing information about identified outliers. The number of rows of the table corresponds to the number of identified outliers. The table has following columns: \code{index} - a numeric value giving the index of detected outlier in the original data, \code{value} - a numeric value of the identified outlier, \code{test.value} - a numeric value of the test statistics, \code{critical.value} - a numeric value giving the test statistics, \code{p.value} - a numeric value giving \emph{p.value} of the test}
\item{outliers.exists}{A logical value. \code{TRUE} means that at least one outlier was detected.}
}
\description{
Sequential identification of outliers using Grubbs' test.
The algorithm first considers the data value with the highest absolute value. If the null hypothesis that such a value is not an outlier is rejected,
the considered value is detected as an outlier and excluded from further analysis. Subsequently, a value with the second-highest absolute value is considered, and its quality is again evaluated using the Grubbs test. This procedure is repeated until no outlier is detected.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and \code{\link{grubbs.detect}}. The function is not intended for use by regular users of the package.
}
\details{
This function sequentially identifies outlier data using Grubbs test.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for identification of outlier residuals using Grubbs test.
}
\references{
Grubbs F (1950). Sample criteria for testing outlying observations. The Annals of Mathematical Statistics, 21(1), 27-58.
}
