% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{segment.length.control}
\alias{segment.length.control}
\title{Segment length control - Only intended for developer use}
\usage{
segment.length.control(index, x, cp.segment, min.segment.length,
  segment.length.for.merge)
}
\arguments{
\item{index}{a numeric vector of design points.}

\item{x}{a numeric vector of data.}

\item{cp.segment}{an integer membership vector for individual segments.}

\item{min.segment.length}{a numeric value giving minimal required number of observations on segments from changepoint analysis.
If a segment contains less than \code{min.segment.length} observations and the variances of data on the segment and the previous one are supposed to be equal (based on Levene´s test (Fox, 2016) for homogeneity of variances), the segment is merged with previous one.
Analogous, the first segment can be merged with the second one.}

\item{segment.length.for.merge}{a numeric value giving giving minimal required number of observations on segments for performing the homogeneity test within changepoint split control.
A segment with fewer data than \code{segment.length.for.merge} is merged with the previous one without testing the homogeneity of variances (the first segment is merged with the second one).}
}
\value{
An integer membership vector for individual segments
}
\description{
Control of a number of data values on individual segments.
In case a number of data values on a segment is too small, the segment is (under the presumption of meeting certain conditions)
merged with the previous one. The first segment can be merged with the previous one.
}
\details{
#' Control of data splitting into segments.
If a segment contains less than a given number of observations specified by the user and the variances of data on the segment and the previous one are equally based on the robust version of Levene's test, the segment is merged with previous one.
Analogous, the first segment can be merged with the second one.
The user can also specify a minimum length of a segment for performing the homogeneity test. A segment with fewer data than this minimal length is merged with the previous one without testing the homogeneity of variances.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\references{
Fox J (2016). Applied regression analysis and generalized linear models. 3 edition. Los Angeles: SAGE. ISBN 9781452205663.
}
