% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{dist.matrix}
\alias{dist.matrix}
\title{Matrix Column Distance}
\usage{
dist.matrix(x, y, method = "euclidean")
}
\arguments{
\item{x, y}{\code{matrix} or \code{Matrix}, of the same number of rows. The columns of \code{x} and \code{y} will be scaled to unit length.}

\item{method}{distance measure, "maximum", "cosine", or "euclidean" are implemented.}
}
\value{
a \code{list} of four components:
\item{dist}{\code{dist}, the distance matrix.}
\item{match}{\code{solve_LSAP}, the column matches.}
\item{value}{\code{numeric} vector, the distance between pairs of columns.}
\item{method}{\code{character}, the distance measure used.}
\item{nrow}{\code{integer}, the dimension of the input matrices, i.e., \code{nrow(x)}.}
}
\description{
Compute the distance between two matrices.
The distance between two matrices is defined as the sum of distances between column pairs.
This function matches the columns of two matrices, such that the matrix distance
(i.e., the sum of paired column distances) is minimized.
This is accomplished by solving an optimization over column permutation.
Given two matrices, \code{x} and \code{y}, find permutation p() that minimizes
sum_i similarity(\verb{x[,p(i)], y[,i]}),
where the \code{similarity()} can be "euclidean" distance, 1 - "cosine", or "maximum" difference (manhattan distance).
The solution is computed by \code{\link[clue:solve_LSAP]{clue::solve_LSAP()}}.
}
\examples{
x <- diag(4)
y <- x + rnorm(16, sd = 0.05) # add some noise
y = t(t(y) / sqrt(colSums(y ^ 2))) ## normalize the columns
## euclidian distance between column pairs, with minimal matches
dist.matrix(x, y, "euclidean")

}
\seealso{
\link[clue:solve_LSAP]{clue::solve_LSAP}
}
