% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_linpred.R
\name{posterior_linpred}
\alias{posterior_linpred}
\title{Gives the posterior linear predictor for the reproduction numbers
Will be extended for observations in future versions}
\usage{
posterior_linpred(
  object,
  transform = FALSE,
  type = NULL,
  newdata = NULL,
  draws = NULL,
  fixed = TRUE,
  random = TRUE,
  autocor = TRUE,
  offset = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{transform}{If TRUE, transforms the predictor by the inverse link function. Defaults
to FALSE.}

\item{type}{If NULL, then gives posterior linear predictor for reproduction numbers.
Otherwise gives the predictor for the specified observation type.}

\item{newdata}{If provided, the original \code{data} used
in \code{object} is overridden. Useful both for counterfactual
and prediction analysis}

\item{draws}{Number of posterior draws to use. Defaults to the number
of parameter draws in the fitted model.}

\item{fixed}{Include fixed effects. Defaults to TRUE.}

\item{random}{Include random effects. Defaults to TRUE.}

\item{autocor}{Include autocorrelation terms. Defaults to TRUE.}

\item{offset}{Include offsets. Defaults to TRUE.}

\item{...}{Not used.}
}
\value{
A list containing the parameter draws and associated groups and dates.
}
\description{
Gives the posterior linear predictor for the reproduction numbers
Will be extended for observations in future versions
}
