% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leslie.R
\name{leslie}
\alias{leslie}
\title{A function to calculate asymptotic growth, sensitivity and elasticity for age-structured populations}
\usage{
leslie(L)
}
\arguments{
\item{L}{the Leslie matrix}
}
\value{
A list consisting of the following components: 
\item{lambda}{the dominant eigen value of the Leslie matrix.}
\item{right.eigenvector}{the dominant right eigen vector of the Leslie matrix, proportional to the stable age-distribution.}
\item{left.eigenvector}{the dominant left eigen vector of the Leslie matrix representing the age-specific reproductive values.}
\item{elasticity}{the elasticities.}
\item{sensitivity}{the sensitivities.}
}
\description{
A function to calculate asymptotic growth, sensitivity and elasticity for age-structured populations
}
\examples{
fa<-c(0, 0.5, 1.2)
sa<-c(0.8, 0.8, 0)
L<-matrix(0, nrow=3, ncol=3)
#inserting fa vector in first row
L[1,]<-fa
#inserting sa in the subdiagonal:
L[row(L)==col(L)+1] <-sa[1:2]
leslie(L)
}
\references{
Caswell, H. 2001.  Matrix Population Models: Construction, Analysis, and Interpretation. 2nd edn Sinauer Associates Inc., Sunderland, MA,
}
