% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printMethods.R
\name{print.Population}
\alias{print.Population}
\title{Print function for population.}
\usage{
\method{print}{Population}(x, ...)
}
\arguments{
\item{x}{a valid \code{Population} object}

\item{...}{additional parameters (ignored)}
}
\description{
Print a summary of the population object.
}
\details{
This is an S3 method for printing a summary of a \code{Population}
object. Displayed are the initial parameters for the population
(i.e. population size, phenotypic variance, broad-sense
heritability, narrow-sense heritability and the SNPs used as
QTLs), followed by any current additive and epistatic variance in
the population.
}
\examples{
# Build a population
pop <- Population(
  popSize = 100, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100), broadH2 = 0.9,
  narrowh2 = 0.5, traitVar = 40
)
pop <- addEffects(pop)
pop <- attachEpiNet(pop)

# Print the initial population
pop

# Run population in simulation
pop2 <- runSim(pop, generations = 150)

# Print the population following the simulation
pop2
}
\seealso{
\code{\link{Population}}, \code{\link{addEffects}},
\code{\link{attachEpiNet}}, \code{\link{runSim}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
