% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getEpiNet}
\alias{getEpiNet}
\title{Epistatic network retrieval.}
\usage{
getEpiNet(pop)
}
\arguments{
\item{pop}{An object of class \code{'Population'} which has an
\code{EpiNet} object attached.}
}
\value{
An object of class \code{'EpiNet'} is returned.
}
\description{
Get an epistatic network from a \code{Population} object.
}
\details{
\code{getEpiNet()} is merely a function for retrieving an
epistatic network object. The common purpose is to plot the
network.
}
\examples{
# Create population and attach an epistatic network
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0, traitVar = 40
)
pop <- attachEpiNet(pop)

# Plot epistatic network
epiNet <- getEpiNet(pop)
plot(epiNet)
}
\seealso{
\code{\link{Population}}, \code{\link{plot.EpiNet}},
\code{\link{attachEpiNet}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
