% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_parameters.epiparameter}
\alias{get_parameters.epiparameter}
\alias{get_parameters.multi_epiparameter}
\title{Get parameters from an \verb{<epiparameter>} object}
\usage{
\method{get_parameters}{epiparameter}(x, ...)

\method{get_parameters}{multi_epiparameter}(x, ...)
}
\arguments{
\item{x}{An \verb{<epiparameter>} object.}

\item{...}{\link{dots} Not used, extra arguments supplied will cause a warning.}
}
\value{
A named vector of parameters or \code{NA} when the \verb{<epiparameter>}
object is unparameterised.
}
\description{
Extract the parameters of the distribution stored in an \verb{<epiparameter>}
object.
}
\details{
The \verb{<epiparameter>} object can be unparameterised in which it lacks
a probability distribution or parameters of a probability distribution,
in this case the \code{get_parameters.epiparameter()} method will return \code{NA}.
}
\examples{
ep <- epiparameter_db(
  disease = "COVID-19",
  epi_name = "serial interval",
  single_epiparameter = TRUE
)
get_parameters(ep)
}
