% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiHSIC.R
\name{epiHSIC}
\alias{epiHSIC}
\title{Calculate HSIC values}
\usage{
epiHSIC(A = NULL, B = NULL, P = NULL, ...)
}
\arguments{
\item{A}{is one matrix.}

\item{B}{is one matrix.}

\item{P}{is "phenoype", a vector.}

\item{...}{not used.}
}
\value{
a matrix
}
\description{
Calculate HSIC values
}
\examples{
 
# simulate some data
set.seed(123)
geno1 <- matrix(sample(0:2, size = 1000, replace = TRUE, prob = c(0.5, 0.3, 0.2)), ncol = 10)
geno2 <- matrix(sample(0:2, size = 2000, replace = TRUE, prob = c(0.4, 0.3, 0.3)), ncol = 20)
dimnames(geno1) <- list(row = paste0("IND", 1:nrow(geno1)), col = paste0("rs", 1:ncol(geno1)))
dimnames(geno2) <- list(row = paste0("IND", 1:nrow(geno2)), col = paste0("exm", 1:ncol(geno2)))

epiHSIC(A = scale(geno1),
B = scale(geno2),
P = rnorm(100))
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de}
}
