% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EPIBLASTER.R
\name{epiblaster2genos}
\alias{epiblaster2genos}
\title{Parallelized calculattion of the difference of correlation coefficients and compute Z test with two genotype inputs}
\usage{
epiblaster2genos(geno1, geno2, pheno, chunk = 1000, zpthres = 1e-05,
  outfile = "NONE", suffix = ".txt", ...)
}
\arguments{
\item{geno1}{is the first normalized genotype data. It can be a matrix or a dataframe, or a big.matrix object from \pkg{bigmemory}. 
The columns contain the information of variables and the rows contain the information of samples.}

\item{geno2}{is the second normalized genotype data. It can be a matrix or a dataframe, or a big.matrix object from \pkg{bigmemory}. 
The columns contain the information of variables and the rows contain the information of samples.}

\item{pheno}{a vector containing the binary phenotype information (case/control). The values are either 0 (control) or 1 (case).}

\item{chunk}{is the number of variants in each chunk.}

\item{zpthres}{is the significance threshold to select variant pairs for output. Default is 1e-6.}

\item{outfile}{is the prefix of out filename.}

\item{suffix}{is the suffix of out filename.}

\item{...}{not used.}
}
\value{
null
}
\description{
Calculate the difference of correlation coeficents between cases and controls,
conduct Z test for the differences (values) and choose variant pairs with the significance below the given threshold for output.
}
\examples{
# simulate some data
set.seed(123)
geno1 <- matrix(sample(0:2, size = 1000, replace = TRUE, prob = c(0.5, 0.3, 0.2)), ncol = 10)
geno2 <- matrix(sample(0:2, size = 2000, replace = TRUE, prob = c(0.4, 0.3, 0.3)), ncol = 20)
dimnames(geno1) <- list(row = paste0("IND", 1:nrow(geno1)), col = paste0("rs", 1:ncol(geno1)))
dimnames(geno2) <- list(row = paste0("IND", 1:nrow(geno2)), col = paste0("exm", 1:ncol(geno2)))
p1 <- c(rep(0, 60), rep(1, 40))

# normalized data
geno1 <- scale(geno1)
geno2 <- scale(geno2)

# two genotypes with quantitative phenotype
epiblaster2genos(geno1 = geno1, 
geno2 = geno2, 
pheno = p1, outfile = "episcan_2geno_cc", 
suffix = ".txt", 
zpthres = 0.9, 
chunk = 10)

# take a look at the result
res <- read.table("episcan_2geno_cc.txt", 
header = TRUE, 
stringsAsFactors = FALSE)
head(res)
}
