% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probsens.conf.R
\name{probsens.conf}
\alias{probsens.conf}
\title{Probabilistic sensitivity analysis for unmeasured confounding.}
\usage{
probsens.conf(case, exposed, reps = 1000, prev.exp = list(dist =
  c("constant", "uniform", "triangular", "trapezoidal", "logit-logistic",
  "logit-normal"), parms = NULL), prev.nexp = list(dist = c("constant",
  "uniform", "triangular", "trapezoidal", "logit-logistic", "logit-normal"),
  parms = NULL), risk = list(dist = c("constant", "uniform", "triangular",
  "trapezoidal", "log-logistic", "log-normal"), parms = NULL), corr.p = NULL,
  discard = TRUE, alpha = 0.05)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated against.}

\item{exposed}{Exposure variable.}

\item{reps}{Number of replications to run.}

\item{prev.exp}{List defining the prevalence of exposure among the exposed. The first argument provides the probability distribution function (constant, uniform, triangular, trapezoidal, logit-logistic, or logit-normal) and the second its parameters as a vector:
\enumerate{
\item Constant: constant value,
\item Uniform: min, max,
\item Triangular: lower limit, upper limit, mode,
\item Trapezoidal: min, lower mode, upper mode, max.
\item Logit-logistic: location, scale, lower bound shift, upper bound shift,
\item Logit-normal: location, scale, lower bound shift, upper bound shift.
}}

\item{prev.nexp}{List defining the prevalence of exposure among the unexposed.}

\item{risk}{List defining the confounder-disease relative risk or the confounder-exposure odds ratio. The first argument provides the probability distribution function (constant, uniform, triangular, trapezoidal, log-logistic, or log-normal) and the second its parameters as a vector:
\enumerate{
\item Constant: constant value,
\item Uniform: min, max,
\item Triangular: lower limit, upper limit, mode,
\item Trapezoidal: min, lower mode, upper mode, max.
\item Log-logistic: location, scale,
\item Log-normal: location, scale.
}}

\item{corr.p}{Correlation between the exposure-specific confounder prevalences.}

\item{discard}{A logical scalar. In case of negative adjusted count, should the draws be discarded? If set to FALSE, negative counts are set to zero.}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{obs.measures}{A table of observed relative risk and odds ratio with confidence intervals.}
\item{adj.measures}{A table of corrected relative risks and odds ratios.}
\item{sim.df}{Data frame of random parameters and computed values.}
}
\description{
Probabilistic sensitivity analysis to correct for unknown or unmeasured confounding and random error simultaneously.
}
\examples{
# The data for this example come from:
# Tyndall M.W., Ronald A.R., Agoki E., Malisa W., Bwayo J.J., Ndinya-Achola J.O. et al.
# Increased risk of infection with human immunodeficiency virus type 1 among
# uncircumcised men presenting with genital ulcer disease in Kenya.
# Clin Infect Dis 1996;23:449-53.
set.seed(123)
probsens.conf(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")), nrow = 2, byrow = TRUE),
reps = 20000,
prev.exp = list("triangular", c(.7, .9, .8)),
prev.nexp = list("trapezoidal", c(.03, .04, .05, .06)),
risk = list("triangular", c(.6, .7, .63)),
corr.p = .8)
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative Bias Analysis to Epidemiologic Data}, pp.117--150, Springer.
}
